
#ifndef LISTA_H
#define LISTA_H

typedef struct _Node
{
	int x;
	struct _Node * next;
} Node;

typedef struct _List
{
	Node * head;
} List;



/** Crea un nodo
 * @return Estructura de nodo, NULL en caso de error
 */
Node * createNode(int x, Node * next);

void freeNode(Node * n);

/** Crea una lista
 * @return Estructura de lista, NULL en caso de error
 */
List * createList();

/** Libera una lista
 * @param l Lista
 */
void freeList(List * l);

/** Retorna el largo de la lista
 * @param l Lista
 * @return largo de la lista
 */
int length(List * l);

/** Inserta el elemento x en la posicion n.
 * En caso de que n sea mayor al largo de la lista, se insertara x al final
 * @param l Lista
 * @param x elemento a insertar
 * @param n posicion
 * @return 0 en caso de error
 */
int insert(List * l, int x, int n);

/** Borra el elemento n
 * @param l Lista
 * @param n posicion a borrar
 * @return 0 en caso de error
 */
int delete(List * l, int n);

/** Borra una llave dada
 * @param l Lista
 * @param x Elemento
 * @return 0 en caso de error
 */
int deleteKey(List * l, int x);

/** Obtiene el elemento i-esimo
 * @param l Lista
 * @param n Posicion a obtener
 * @return El elemento y -1 en caso de error
 */
int get(List * l, int n);

#endif
