#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

typedef struct _Node
{
	int x;
	struct _Node * next;
} Node;

typedef struct _Stack
{
	Node * head;
} Stack;

Node * createNode(int x, Node * next)
{
	Node * ret = (Node*)malloc(sizeof(Node));
	assert(ret!=NULL);
	ret->x = x;
	ret->next = next;
	return ret;
}

Stack * createStack()
{
	Stack * ret = (Stack*)malloc(sizeof(Stack));
	assert(ret!=NULL);
	ret->head = NULL;
	return ret;
}

void freeNode(Node * n)
{
	if(n==NULL)
		return;
	freeNode(n->next);
	free(n);
}

void freeStack(Stack * s)
{
	freeNode(s->head);
	free(s);
}

void push(Stack * s, int x)
{
	Node * newHead = createNode(x, s->head);
	assert(newHead!=NULL);
	s->head = newHead;
}

int top(Stack * s)
{
	if(s->head!=NULL)
		return s->head->x;
	else
		return -1;
}

int pop(Stack * s)
{
	int x;
	Node * aux;
	assert(s->head!=NULL);
	x = s->head->x;
	aux = s->head;
	s->head = s->head->next;
	aux->next = NULL;
	freeNode(aux);
	return x;
}

int isEmpty(Stack * s)
{
	return s->head==NULL;
}

int length(Stack * s)
{
	int n;
	Node * aux = s->head;
	for(n=0;aux!=NULL;n++, aux=aux->next);
	return n;
}
