
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>

typedef struct _Node
{
	int x;
	struct _Node * next;
} Node;

typedef struct _List
{
	Node * head;
} List;



/** Crea un nodo
 * @return Estructura de nodo, NULL en caso de error
 */
Node * createNode(int x, Node * next)
{
	Node * n = (Node *)malloc(sizeof(Node));
	if(n==NULL)
		return n;
	n->x = x;
	n->next = next;
	return n;
}

void freeNode(Node * n)
{
	if(n==NULL)
		return;
	freeNode(n->next);
	free(n);
}

/** Crea una lista
 * @return Estructura de lista, NULL en caso de error
 */
List * createList()
{
	List * l = (List *)malloc(sizeof(List));
	if(l==NULL)
		return l;
	l->head=NULL;
	return l;
}

/** Libera una lista
 * @param l Lista
 */
void freeList(List * l)
{
	freeNode(l->head);
	free(l);
}

/** Retorna el largo de la lista
 * @param l Lista
 * @return largo de la lista
 */
int length(List * l)
{
	Node * aux;
	int c = 0;
	if(l==NULL)
		return 0;
	aux = l->head;
	for(;aux!=NULL; aux = aux->next, c++);
	return c;
}

/** Inserta el elemento x en la posicion n.
 * En caso de que n sea mayor al largo de la lista, se insertara x al final
 * @param l Lista
 * @param x elemento a insertar
 * @param n posicion
 * @return 0 en caso de error
 */
int insert(List * l, int x, int n)
{
	int c;
	Node * aux;
	int l_len;
	l_len = length(l);
	if(n==0 || l_len==0)
	{
		l->head = createNode(x,l->head);
		return l->head!=NULL;
	}
	if(l_len<n)
		n = l_len;
	n--;
	for(aux = l->head, c=0; c < n; c++, aux=aux->next);
	aux->next = createNode(x,aux->next);
	return aux->next!=NULL;
}


/** Borra el elemento n
 * @param l Lista
 * @param n posicion a borrar
 * @return 0 en caso de error
 */
int delete(List * l, int n)
{
	int c;
	Node * aux;
	Node * borrado;
	int l_len = length(l);
	if(n==0)
	{
		if(l->head!=NULL)
		{
			aux = l->head;
			l->head = aux->next;
			aux->next = NULL;
			freeNode(aux);
			return 1;
		}
		return 0;
	}
	if(l_len<n)
		return 0;
	n--;
	for(aux = l->head, c=0; c < n; c++, aux=aux->next);
	borrado = aux->next;
	aux->next = aux->next->next;
	borrado->next = NULL;
	freeNode(borrado);
	return 1;
}

/** Borra una llave dada
 * @param l Lista
 * @param x Elemento
 * @return 0 en caso de error
 */
int deleteKey(List * l, int x)
{
	Node * aux;
	Node * borrado;
	while(l->head!=NULL)
	{
		if(l->head->x == x)
		{
			borrado = l->head;
			l->head = l->head->next;
			borrado->next=NULL;
			freeNode(borrado);
		}
		else
			break;
	}
	if(l->head == NULL) 
		return 1;
	for(aux = l->head; aux->next!=NULL;aux=aux->next)
		if(aux->next->x == x)
		{
			borrado = aux->next;
			aux->next = aux->next->next;
			borrado->next=NULL;
			freeNode(borrado);
		}
	return 1;
}

/** Obtiene el elemento i-esimo
 * @param l Lista
 * @param n Posicion a obtener
 * @return El elemento y -1 en caso de error
 */
int get(List * l, int n)
{
	Node * aux = l->head;
	int j;
	if(n>length(l))
		return -1;
	for(j = 0; j < n; j++)
		aux = aux->next;
	return aux->x;
}

