
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "lista.h"

typedef struct _Set 
{
	List * l;
} Set;

Set * createSet()
{
	Set * s = (Set *)malloc(sizeof(Set));
	assert(s!=NULL);
	s->l = createList();
	return s;
}

void freeSet(Set * s)
{
	if(s->l!=NULL)
		freeList(s->l);
	free(s);
}

int add(Set * s, int x)
{
	int i,n;
	n = length(s->l);
	for(i=0;i<n;i++)
		if(get(s->l,i)==x)
			return 1;
	return insert(s->l,x,n+1);
}

int del(Set * s, int x)
{
	return deleteKey(s->l, x);
}

Set * unir(Set * s1, Set * s2)
{
	int i,n;
	Set * ret = createSet();
	n = length(s1->l);
	for(i=0;i<n;i++)
		add(ret, get(s1->l,i));
	n = length(s2->l);
	for(i=0;i<n;i++)
		add(ret, get(s2->l,i));
	return ret;
}

int pertenece(Set * s, int x)
{
	int i,n;
	n = length(s->l);
	for(i=0;i<n;i++)
		if(get(s->l,i)==x)
			return 1;
	return 0;
}

Set * inter(Set * s1, Set * s2)
{
	int i, n;
	Set * ret = createSet();
	n = length(s1->l);
	for(i=0;i<n;i++)
		if(pertenece(s2,get(s1->l,i)))
			add(ret, get(s1->l,i));
	return ret;
}

void print(Set * s, char * str)
{
	int i,n;
	n = length(s->l);
	printf("%s = {",str);
	for(i=0;i<n;i++)
		printf(" [%d] ",get(s->l,i));
	printf("}\n");
}

int main()
{
	Set * c1, * c2, * c3, * c4, * c5;
	c1 = createSet();
	c2 = createSet();
	c3 = createSet();
	add(c1,1); add(c1,2); add(c1,3);
	add(c2,1); add(c2,4); add(c2,5);
	c4 = inter(c1,c2);
	c5 = unir(c1,c2);
	print(c1,"c1");
	print(c2,"c2");
	print(c4,"c4 (c1 inter c2)");
	print(c5,"c5 (c1 union c2)");
	freeSet(c4); freeSet(c5);
	c4 = inter(c1,c3);
	c5 = unir(c1,c3);
	print(c1,"c1");
	print(c3,"c3");
	print(c4,"c4 (c1 inter c3)");
	print(c5,"c5 (c1 union c3)");
	freeSet(c1); freeSet(c2); freeSet(c3);
	freeSet(c4); freeSet(c5);
	return 0;	
}

