/*
 * Decompiled with CFR 0.152.
 */
package jpdf;

import jpdf.PDFType;

public class PDFPowerLaw
extends PDFType {
    double min;
    double beta;

    public PDFPowerLaw(double[] X) {
        this.min = X[0];
        for (int i = 1; i < X.length; ++i) {
            if (!(this.min > X[i])) continue;
            this.min = X[i];
        }
        double ln = 0.0;
        for (int i = 0; i < X.length; ++i) {
            ln += Math.log(X[i] - this.min + 1.0);
        }
        this.beta = 1.0 + 1.0 / (ln /= (double)X.length);
    }

    @Override
    public double cdfEval(double x) {
        if (x < this.min || this.beta <= 1.0) {
            return 0.0;
        }
        return 1.0 - Math.pow(x - this.min + 1.0, 1.0 - this.beta);
    }

    @Override
    public double pdfEval(double x) {
        if (x < this.min || this.beta <= 1.0) {
            return 0.0;
        }
        return (this.beta - 1.0) * Math.pow(x - this.min + 1.0, -this.beta);
    }

    public String toString() {
        String s = this.min == 1.0 ? "PowerLaw distribution, with f(x) = " + PDFPowerLaw.shortDouble(this.beta - 1.0) + "*x^-" + PDFPowerLaw.shortDouble(this.beta) + ", and x >= " + this.min : (this.min > 1.0 ? "PowerLaw distribution, with f(x) = " + PDFPowerLaw.shortDouble(this.beta - 1.0) + "*(x-" + (this.min - 1.0) + ")^-" + PDFPowerLaw.shortDouble(this.beta) + ", and x >= " + this.min : "PowerLaw distribution, with f(x) = " + PDFPowerLaw.shortDouble(this.beta - 1.0) + "*(x+" + PDFPowerLaw.shortDouble(1.0 - this.min) + ")^-" + PDFPowerLaw.shortDouble(this.beta) + ", and x >= " + this.min);
        return s;
    }
}

