/*
 * Decompiled with CFR 0.152.
 */
package jpdf;

import jpdf.PDFNormal;
import jpdf.PDFType;

public class PDFBoxCox
extends PDFType {
    double min;
    double geom;
    double L;
    PDFNormal normal;

    public PDFBoxCox(double[] X) {
        int i;
        this.min = X[0];
        for (i = 1; i < X.length; ++i) {
            if (!(this.min > X[i])) continue;
            this.min = X[i];
        }
        if (this.min >= 1.0) {
            this.min = 0.0;
        }
        this.geom = 1.0;
        for (i = 1; i < X.length; ++i) {
            this.geom *= Math.pow(X[i] + 1.0 - this.min, 1.0 / (double)X.length);
        }
        this.L = 1.0;
        this._fit2data(X);
    }

    private void _fit2data(double[] X) {
        double[] Y = new double[X.length];
        double Lmin = 0.0;
        double Lmax = 4.0;
        for (int i = 0; i < 15; ++i) {
            double std;
            double var;
            for (int j = 0; j < X.length; ++j) {
                double u;
                if (this.L < 0.01) {
                    this.L = 0.0;
                    u = Math.log(X[j] - this.min + 1.0);
                } else {
                    u = Math.pow(X[j] - this.min + 1.0, this.L) - 1.0;
                    u = u / this.L / Math.pow(this.geom, this.L - 1.0);
                }
                Y[j] = u;
            }
            double skw = this.skewness(Y);
            if (skw <= 0.01 * (var = this.variance(Y)) * (std = Math.sqrt(var)) && -skw <= 0.01 * var * std) break;
            if (skw > 0.0) {
                Lmax = this.L;
            } else {
                Lmin = this.L;
            }
            this.L = (Lmax + Lmin) / 2.0;
        }
        this.normal = new PDFNormal(Y);
    }

    @Override
    public double cdfEval(double x) {
        if (x < this.min || this.L == 1.0) {
            return 0.0;
        }
        double u = Math.pow(x - this.min + 1.0, this.L) - 1.0;
        u = u / this.L / Math.pow(this.geom, this.L - 1.0);
        if (this.L == 0.0) {
            u = Math.log(x + 1.0 - this.min);
        }
        return this.normal.cdfEval(u);
    }

    @Override
    public double pdfEval(double x) {
        if (x < this.min || this.L == 1.0) {
            return 0.0;
        }
        if (this.L == 0.0) {
            return this.normal.pdfEval(Math.log(x - this.min + 1.0)) / (x - this.min + 1.0);
        }
        double u = Math.pow(x - this.min + 1.0, this.L) - 1.0;
        u = u / this.L / Math.pow(this.geom, this.L - 1.0);
        double v = Math.pow((x - this.min + 1.0) / this.geom, this.L - 1.0);
        return v * this.normal.pdfEval(u);
    }

    public String toString() {
        String s = "Box-Cox distribution, where y = ";
        s = this.L < 0.01 ? s + "log(x + " + PDFBoxCox.shortDouble(1.0 - this.min) + "), i.e. x is lognormal" : (this.min == 0.0 ? s + "( x^" + PDFBoxCox.shortDouble(this.L) + " - 1 )*" + PDFBoxCox.shortDouble(Math.pow(this.geom, 1.0 - this.L) / this.L) : s + "( [x+" + PDFBoxCox.shortDouble(1.0 - this.min) + "]^" + PDFBoxCox.shortDouble(this.L) + " - 1 )*" + PDFBoxCox.shortDouble(Math.pow(this.geom, 1.0 - this.L) / this.L));
        s = s + ",\n    and y follows a " + this.normal;
        return s;
    }

    private double variance(double[] V) {
        int i;
        double var = 0.0;
        double avg = 0.0;
        for (i = 0; i < V.length; ++i) {
            avg += V[i];
        }
        avg /= (double)V.length;
        for (i = 0; i < V.length; ++i) {
            var += (V[i] - avg) * (V[i] - avg);
        }
        return var /= (double)(V.length - 1);
    }

    private double skewness(double[] V) {
        int i;
        double skew = 0.0;
        double avg = 0.0;
        for (i = 0; i < V.length; ++i) {
            avg += V[i];
        }
        avg /= (double)V.length;
        for (i = 0; i < V.length; ++i) {
            skew += (V[i] - avg) * (V[i] - avg) * (V[i] - avg);
        }
        return skew /= (double)(V.length - 1);
    }
}

