/*
 * Decompiled with CFR 0.152.
 */
package jpdfGUI;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import jpdf.JointPDF;
import jpdfGUI.StaticTools;
import jpdfGUI.plotGraph;

public class MainGUI
extends JFrame {
    JFileChooser JFC = null;
    JointPDF JPDF = null;
    File csv = null;
    plotGraph PL = null;
    double[][] data;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JTextArea jTextArea1;
    private JTextField jTextField1;
    private JTextField jTextField2;

    public MainGUI() {
        this.initComponents();
        this.jPanel2.setLayout(new BorderLayout());
        this.PL = new plotGraph();
        this.jPanel2.add(this.PL);
        this.pack();
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jButton2 = new JButton();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jPanel4 = new JPanel();
        this.jButton3 = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.setDefaultCloseOperation(3);
        this.setTitle("Joint PDF estimator");
        this.setBackground(new Color(255, 255, 255));
        this.setBounds(new Rectangle(0, 0, 600, 400));
        this.setForeground(new Color(255, 255, 255));
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/jpdfGUI/banner.png")));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "File open menu", 1, 2, new Font("Dialog", 0, 12)));
        this.jPanel1.setAutoscrolls(true);
        this.jButton1.setText("Open CSV file");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Dialog", 0, 10));
        this.jLabel1.setText("First, open a CSV file with numerical data.");
        this.jLabel3.setFont(new Font("Dialog", 0, 10));
        this.jLabel3.setText("Titles should be in the first row.");
        this.jButton2.setText("Refresh graph");
        this.jButton2.setEnabled(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1).addComponent(this.jLabel1).addComponent(this.jLabel3).addComponent(this.jButton2)).addContainerGap(28, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addContainerGap(47, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Sample F (x) vs Estimated F (y)", 1, 2, new Font("Dialog", 0, 12)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 244, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 271, Short.MAX_VALUE));
        this.jPanel2.getAccessibleContext().setAccessibleName("Sample F vs Estimated F");
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Estimated JPDF description", 1, 2, new Font("Dialog", 0, 12)));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setFont(new Font("Dialog", 0, 11));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("<No data>");
        this.jTextArea1.setEnabled(false);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 327, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 281, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Evaluate a point", 0, 0, new Font("Dialog", 0, 12)));
        this.jButton3.setText("Evaluate");
        this.jButton3.setEnabled(false);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jButton3ActionPerformed(evt);
            }
        });
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"X0", "X1"}));
        this.jTable1.setAutoResizeMode(4);
        this.jTable1.setEnabled(false);
        this.jTable1.setMinimumSize(new Dimension(75, 16));
        this.jScrollPane2.setViewportView(this.jTable1);
        this.jTextField1.setFont(new Font("Dialog", 0, 11));
        this.jTextField1.setText("<No data>");
        this.jTextField1.setEnabled(false);
        this.jTextField2.setFont(new Font("Dialog", 0, 11));
        this.jTextField2.setText("<No data>");
        this.jTextField2.setEnabled(false);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 303, Short.MAX_VALUE).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField2, -1, 211, Short.MAX_VALUE).addComponent(this.jTextField1, -1, 211, Short.MAX_VALUE)))).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 51, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton3).addComponent(this.jTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addContainerGap()).addComponent(this.jLabel2, -2, 621, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        double[] X = new double[this.data[0].length];
        for (int i = 0; i < X.length; ++i) {
            X[i] = Double.parseDouble(this.jTable1.getValueAt(0, 0).toString());
        }
        this.jTextField1.setText("(jpdf) f=" + this.JPDF.pdfEval(X));
        this.jTextField2.setText("(jcdf) F=" + this.JPDF.cdfEval(X));
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.PL.setData(this.JPDF.doubleSample(this.data, 600));
        this.PL.repaint();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.JFC == null) {
            this.JFC = new JFileChooser();
        }
        this.JFC.setDialogTitle("Open CSV file");
        this.JFC.showOpenDialog(this);
        this.csv = this.JFC.getSelectedFile();
        this.jButton1.setEnabled(false);
        this.jButton2.setEnabled(false);
        this.jButton3.setEnabled(false);
        this.jTable1.setEnabled(false);
        this.jTextArea1.setEnabled(false);
        this.jTextField1.setEnabled(false);
        this.jTextField2.setEnabled(false);
        Thread TH = new Thread(){

            @Override
            public void run() {
                try {
                    4.sleep(1L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                String[] titles = StaticTools.CSVtitles(MainGUI.this.csv.getAbsoluteFile());
                MainGUI.this.data = StaticTools.openCSV(MainGUI.this.csv.getAbsoluteFile());
                MainGUI.this.JPDF = new JointPDF(MainGUI.this.data);
                MainGUI.this.jButton1.setEnabled(true);
                MainGUI.this.jButton2.setEnabled(true);
                MainGUI.this.jButton3.setEnabled(true);
                MainGUI.this.jTable1.setEnabled(true);
                MainGUI.this.jTextArea1.setEnabled(true);
                MainGUI.this.jTextField1.setEnabled(true);
                MainGUI.this.jTextField1.setText("");
                MainGUI.this.jTextField2.setEnabled(true);
                MainGUI.this.jTextField2.setText("");
                MainGUI.this.jTextArea1.setText(MainGUI.this.JPDF.toString());
                MainGUI.this.PL.setData(MainGUI.this.JPDF.doubleSample(MainGUI.this.data, 600));
                MainGUI.this.PL.repaint();
                Object[][] p1 = new Object[1][titles.length];
                Object[] p2 = new String[titles.length];
                for (int i = 0; i < titles.length; ++i) {
                    p1[0][i] = new Double(MainGUI.this.data[0][i]);
                    p2[i] = "X" + (i + 1) + " (" + titles[i] + ")";
                }
                MainGUI.this.jTable1.setModel(new DefaultTableModel(p1, p2));
            }
        };
        try {
            TH.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainGUI().setVisible(true);
            }
        });
    }
}

