/*
 * Decompiled with CFR 0.152.
 */
package jpdf;

import jpdf.PDFType;

public class PDFUniform
extends PDFType {
    double min;
    double max;

    public PDFUniform(double[] X) {
        this.min = this.max = X[0];
        for (int i = 1; i < X.length; ++i) {
            if (this.min > X[i]) {
                this.min = X[i];
            }
            if (!(this.max < X[i])) continue;
            this.max = X[i];
        }
    }

    @Override
    public double cdfEval(double x) {
        if (this.max == this.min) {
            return 0.0;
        }
        if (x < this.min) {
            return 0.0;
        }
        if (x > this.max) {
            return 1.0;
        }
        return (x - this.min) / (this.max - this.min);
    }

    @Override
    public double pdfEval(double x) {
        if (this.max == this.min) {
            return 0.0;
        }
        if (x < this.min || x > this.max) {
            return 0.0;
        }
        return 1.0 / (this.max - this.min);
    }

    public String toString() {
        String s = "Uniform distribution, with f(x) = " + PDFUniform.shortDouble(1.0 / (this.max - this.min)) + ", and x in [" + PDFUniform.shortDouble(this.min) + "," + PDFUniform.shortDouble(this.max) + "]";
        return s;
    }
}

