/*
 * Decompiled with CFR 0.152.
 */
package jpdf;

import jpdf.PDFBoxCox;
import jpdf.PDFExponential;
import jpdf.PDFNormal;
import jpdf.PDFPowerLaw;
import jpdf.PDFTriangular;
import jpdf.PDFUniform;

public abstract class PDFType {
    public static PDFType autoFit(double[] D) {
        double actR = 0.0;
        double propR = 0.0;
        PDFType act = new PDFUniform(D);
        actR = act.fitness(D);
        PDFType prop = new PDFExponential(D);
        propR = prop.fitness(D);
        if (propR > actR) {
            act = prop;
            actR = propR;
        }
        if ((propR = (prop = new PDFPowerLaw(D)).fitness(D)) > actR) {
            act = prop;
            actR = propR;
        }
        if ((propR = (prop = new PDFNormal(D)).fitness(D)) > actR) {
            act = prop;
            actR = propR;
        }
        if ((propR = (prop = new PDFTriangular(D)).fitness(D)) >= actR) {
            act = prop;
            actR = propR;
        }
        if (actR <= 0.96 && (propR = (prop = new PDFBoxCox(D)).fitness(D)) >= actR) {
            act = prop;
            actR = propR;
        }
        System.out.println(actR);
        return act;
    }

    protected static double _fitness(double[] A, double[] B) {
        int i;
        double aa = 0.0;
        double ab = 0.0;
        double bb = 0.0;
        double a = 0.0;
        double b = 0.0;
        for (i = 0; i < A.length; ++i) {
            a += A[i] / 100.0;
            b += B[i] / 100.0;
        }
        a /= (double)A.length;
        b /= (double)A.length;
        for (i = 0; i < A.length; ++i) {
            aa += (A[i] / 100.0 - a) * (A[i] / 100.0 - a);
            ab += (A[i] / 100.0 - a) * (B[i] / 100.0 - b);
            bb += (B[i] / 100.0 - b) * (B[i] / 100.0 - b);
        }
        if ((bb /= (double)A.length) == 0.0 || (aa /= (double)A.length) == 0.0 || (ab /= (double)A.length) == 0.0) {
            return 0.0;
        }
        double q1 = ab / aa * ab / bb;
        double q2 = 1.0 - Math.abs(ab / bb);
        double q3 = 1.0 - Math.abs(a - ab * b / bb);
        return q1 * (q2 + q3) / 2.0;
    }

    public abstract double cdfEval(double var1);

    public abstract double pdfEval(double var1);

    public double fitness(double[] X) {
        int N = X.length < 80 ? X.length : 80;
        double[] Y = PDFType._sort(X);
        double[] U = new double[N];
        double[] V = new double[N];
        for (int i = 0; i < N; ++i) {
            int j;
            double val = Y[0] + (Y[N - 1] - Y[0]) * ((double)i + 0.5) / (double)N;
            U[i] = this.cdfEval(val);
            for (j = (int)(U[i] * (double)X.length); !(j <= 0 || j >= X.length || Y[j] >= val && Y[j - 1] <= val); j += Y[j] < val ? 1 : -1) {
            }
            V[i] = j;
        }
        return PDFType._fitness(U, V);
    }

    protected static double[] _sort(double[] X) {
        double[] Y = PDFType._clone(X);
        PDFType._sub_sort(Y, 0, Y.length - 1);
        return Y;
    }

    private static void _sub_sort(double[] X, int i, int j) {
        int k;
        if (i >= j) {
            return;
        }
        if (i == j - 1) {
            if (X[i] <= X[j]) {
                return;
            }
            double z = X[j];
            X[j] = X[i];
            X[i] = z;
            return;
        }
        PDFType._sub_sort(X, i, (i + j) / 2);
        PDFType._sub_sort(X, (i + j) / 2 + 1, j);
        double[] tmp = new double[j - i + 1];
        int x = i;
        int y = (i + j) / 2 + 1;
        for (k = 0; k <= j - i; ++k) {
            if (y > j) {
                tmp[k] = X[x];
                ++x;
                continue;
            }
            if (x > (i + j) / 2) {
                tmp[k] = X[y];
                ++y;
                continue;
            }
            if (X[x] < X[y]) {
                tmp[k] = X[x];
                ++x;
                continue;
            }
            tmp[k] = X[y];
            ++y;
        }
        for (k = 0; k <= j - i; ++k) {
            X[i + k] = tmp[k];
        }
    }

    protected static double[] _clone(double[] X) {
        double[] Y = new double[X.length];
        for (int i = 0; i < X.length; ++i) {
            Y[i] = X[i];
        }
        return Y;
    }

    public static double shortDouble(double x) {
        if (x > 100.0 || x < -100.0) {
            return (double)Math.round(x * 10000.0) / 10000.0;
        }
        if (x > 10.0 || x < -10.0) {
            return (double)Math.round(x * 100000.0) / 100000.0;
        }
        return (double)Math.round(x * 1000000.0) / 1000000.0;
    }
}

