/*
 * Decompiled with CFR 0.152.
 */
package jpdf;

import jpdf.PDFType;

public class PDFTriangular
extends PDFType {
    double min;
    double max;
    double mode;

    public PDFTriangular(double[] X) {
        double avg;
        this.max = avg = X[0];
        this.min = avg;
        for (int i = 1; i < X.length; ++i) {
            if (this.min > X[i]) {
                this.min = X[i];
            }
            if (this.max < X[i]) {
                this.max = X[i];
            }
            avg += X[i];
        }
        this.mode = 3.0 * (avg /= (double)X.length) - this.min - this.max;
        if (this.mode > this.max) {
            this.mode = this.max;
        }
        if (this.mode < this.min) {
            this.mode = this.min;
        }
    }

    @Override
    public double pdfEval(double d) {
        if (this.max == this.min) {
            return 0.0;
        }
        if (d < this.min || d > this.max) {
            return 0.0;
        }
        if (d < this.mode) {
            return 2.0 * (d - this.min) / (this.max - this.min) / (this.mode - this.min);
        }
        return 2.0 * (this.max - d) / (this.max - this.min) / (this.max - this.mode);
    }

    @Override
    public double cdfEval(double d) {
        if (this.max == this.min) {
            return 0.0;
        }
        if (d < this.min) {
            return 0.0;
        }
        if (d > this.max) {
            return 1.0;
        }
        if (d < this.mode) {
            return (d - this.min) * (d - this.min) / (this.max - this.min) / (this.mode - this.min);
        }
        return 1.0 - (this.max - d) * (this.max - d) / (this.max - this.min) / (this.max - this.mode);
    }

    public String toString() {
        String s = "Triangular distribution, with min " + PDFTriangular.shortDouble(this.min) + ", max " + PDFTriangular.shortDouble(this.max) + ", and mode " + PDFTriangular.shortDouble(this.mode);
        return s;
    }
}

