/*
 * Decompiled with CFR 0.152.
 */
package jpdf;

import jpdf.PDFType;

public class PDFNormal
extends PDFType {
    double avg = 0.0;
    double std = 0.0;

    public PDFNormal(double[] X) {
        double xx = 0.0;
        for (int i = 0; i < X.length; ++i) {
            this.avg += X[i];
            xx += X[i] * X[i];
        }
        this.avg /= (double)X.length;
        this.std = Math.sqrt((xx /= (double)X.length) - this.avg * this.avg);
    }

    @Override
    public double fitness(double[] X) {
        if (this.std == 0.0) {
            return 0.0;
        }
        return super.fitness(X);
    }

    public static double cdf_01(double x) {
        return 1.0 / (1.0 + Math.pow(Math.E, -1.8138 * x));
    }

    public static double pdf_01(double x) {
        return (PDFNormal.cdf_01(x + 0.01) - PDFNormal.cdf_01(x - 0.01)) / 0.02;
    }

    @Override
    public double cdfEval(double x) {
        if (this.std == 0.0) {
            return 0.0;
        }
        return PDFNormal.cdf_01((x - this.avg) / this.std);
    }

    @Override
    public double pdfEval(double x) {
        if (this.std == 0.0) {
            return 0.0;
        }
        return PDFNormal.pdf_01((x - this.avg) / this.std) / this.std;
    }

    public String toString() {
        String s = "Normal distribution, with avg " + PDFNormal.shortDouble(this.avg) + " and stdev " + PDFNormal.shortDouble(this.std);
        return s;
    }
}

