/*
 * Decompiled with CFR 0.152.
 */
package jpdf;

import jpdf.PDFType;

public class PDFExponential
extends PDFType {
    double min;
    double beta;

    public PDFExponential(double[] X) {
        this.min = X[0];
        for (int i = 1; i < X.length; ++i) {
            if (!(this.min > X[i])) continue;
            this.min = X[i];
        }
        double m = 0.0;
        for (int i = 0; i < X.length; ++i) {
            m += X[i];
        }
        m = m / (double)X.length - this.min;
        this.beta = 1.0 / m;
    }

    @Override
    public double cdfEval(double x) {
        if (x < this.min || this.beta < 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-this.beta * (x - this.min));
    }

    @Override
    public double pdfEval(double x) {
        if (x < this.min || this.beta < 0.0) {
            return 0.0;
        }
        return this.beta * Math.exp(-this.beta * (x - this.min));
    }

    public String toString() {
        String s = this.min == 0.0 ? "Exponential distribution, with f(x) = " + PDFExponential.shortDouble(this.beta) + "*e^[-" + PDFExponential.shortDouble(this.beta) + "*x], and x >= " + PDFExponential.shortDouble(this.min) : (this.min > 0.0 ? "Exponential distribution, with f(x) = " + PDFExponential.shortDouble(this.beta) + "*e^[-" + PDFExponential.shortDouble(this.beta) + "*(x-" + PDFExponential.shortDouble(this.min) + ")], and x >= " + PDFExponential.shortDouble(this.min) : "Exponential distribution, with f(x) = " + PDFExponential.shortDouble(this.beta) + "*e^[-" + PDFExponential.shortDouble(this.beta) + "*(x+" + PDFExponential.shortDouble(-this.min) + ")], and x >= " + PDFExponential.shortDouble(this.min));
        return s;
    }
}

