/*
 * Decompiled with CFR 0.152.
 */
package jpdf;

import jpdf.PDFType;

public class JointPDF {
    private double[][] T;
    private boolean[] valid;
    private PDFType[] marginal;
    private double[] min;
    private double[] max;
    private double quality;

    public JointPDF(double[][] data) {
        this._getMinMax(data);
        this._fit2data(data);
        this.quality = this.fitness(data);
    }

    private void _getMinMax(double[][] data) {
        this.min = new double[data[0].length];
        this.max = new double[data[0].length];
        for (int j = 0; j < data[0].length; ++j) {
            this.min[j] = this.max[j] = data[0][j];
        }
        for (int i = 1; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                if (this.min[j] > data[i][j]) {
                    this.min[j] = data[i][j];
                }
                if (!(this.max[j] < data[i][j])) continue;
                this.max[j] = data[i][j];
            }
        }
    }

    public double fitness(double[][] Z) {
        double[][] _sample = this.doubleSample(Z, 1000);
        return JointPDF._fitness(_sample);
    }

    public double[][] doubleSample(double[][] Z, int N) {
        double[][] S = new double[2000][this.T.length];
        double[] pdfs = new double[2000];
        double sumpdf = 0.0;
        for (int i = 0; i < pdfs.length; ++i) {
            for (int j = 0; j < this.T.length; ++j) {
                S[i][j] = this.min[j] + (this.max[j] - this.min[j]) * Math.random();
            }
            pdfs[i] = this.pdfEval(S[i]);
            sumpdf += pdfs[i];
        }
        double[] d = new double[this.T.length];
        double[][] R = new double[N][2];
        for (int i = 0; i < N; ++i) {
            int k;
            boolean acep;
            int j;
            int k2;
            if (i % 50 == 0) {
                sumpdf = 0.0;
                for (k2 = 0; k2 < pdfs.length; ++k2) {
                    for (int j2 = 0; j2 < this.T.length; ++j2) {
                        S[k2][j2] = this.min[j2] + (this.max[j2] - this.min[j2]) * Math.random();
                    }
                    pdfs[k2] = this.pdfEval(S[k2]);
                    sumpdf += pdfs[k2];
                }
            }
            for (k2 = 0; k2 < this.T.length; ++k2) {
                double u = Math.random();
                if (i % 4 == 1) {
                    u = Math.pow(u, 0.5 / (double)this.T.length);
                }
                if (i % 4 == 2) {
                    u = Math.pow(u, 2.0 / (double)this.T.length);
                }
                if (i % 4 == 3) {
                    u = 1.0 - Math.pow(u, 1.0 / (double)this.T.length);
                }
                d[k2] = this.min[k2] + (this.max[k2] - this.min[k2]) * (1.1 * u - 0.05);
            }
            double X = 0.0;
            for (j = 0; j < S.length; ++j) {
                acep = true;
                for (k = 0; k < this.T.length; ++k) {
                    acep = acep && S[j][k] <= d[k];
                }
                X += acep ? pdfs[j] : 0.0;
            }
            double Y = 0.0;
            for (j = 0; j < Z.length; ++j) {
                acep = true;
                for (k = 0; k < this.T.length; ++k) {
                    acep = acep && Z[j][k] <= d[k];
                }
                Y += acep ? 1.0 : 0.0;
            }
            R[i][0] = Y / (double)Z.length;
            R[i][1] = X / sumpdf;
        }
        return R;
    }

    public String textSample(double[][] Z, int N) {
        String txt = "";
        double[] X = new double[N];
        double[] Y = new double[N];
        double[] d = new double[this.T.length];
        for (int i = 0; i < N; ++i) {
            for (int k = 0; k < this.T.length; ++k) {
                double u = Math.random();
                if (i % 2 == 0) {
                    u = Math.pow(u, 0.25);
                }
                if (i % 4 == 0) {
                    u = 1.0 - u;
                }
                if (i == 0) {
                    u = 1.0;
                }
                if (i == 1) {
                    u = 0.0;
                }
                d[k] = this.min[k] + (this.max[k] - this.min[k]) * 1.1 * u;
            }
            X[i] = this.cdfEval(d);
            Y[i] = 0.0;
            for (int j = 0; j < Z.length; ++j) {
                boolean acep = true;
                for (int k = 0; k < this.T.length; ++k) {
                    acep &= Z[j][k] <= d[k];
                }
                int n = i;
                Y[n] = Y[n] + (acep ? 1.0 : 0.0);
            }
            Y[i] = Y[i] / (double)Z.length;
            txt = txt + X[i] + "," + Y[i] + "\n";
        }
        return txt;
    }

    private static double _fitness(double[] A, double[] B) {
        int i;
        double aa = 0.0;
        double ab = 0.0;
        double bb = 0.0;
        double a = 0.0;
        double b = 0.0;
        for (i = 0; i < A.length; ++i) {
            a += A[i];
            b += B[i];
        }
        a /= (double)A.length;
        b /= (double)A.length;
        for (i = 0; i < A.length; ++i) {
            aa += (A[i] - a) * (A[i] - a);
            ab += (A[i] - a) * (B[i] - b);
            bb += (B[i] - b) * (B[i] - b);
        }
        ab /= (double)A.length;
        if ((bb /= (double)A.length) == 0.0 || (aa /= (double)A.length) == 0.0) {
            System.out.println("error!");
        }
        double c = 1.0 - Math.abs(a - ab / bb * b);
        return ab / aa / bb * ab * c;
    }

    private static double _fitness(double[][] A) {
        int i;
        int i2;
        double aa = 0.0;
        double ab = 0.0;
        double bb = 0.0;
        double a = 0.0;
        double b = 0.0;
        double c = 0.0;
        double d = 0.0;
        double[] W = new double[10];
        for (int i3 = 0; i3 < W.length; ++i3) {
            W[i3] = 0.0;
        }
        int bin = 0;
        for (i2 = 0; i2 < A.length; ++i2) {
            bin = (int)(A[i2][0] * (double)W.length);
            if (bin == W.length) {
                // empty if block
            }
            int n = --bin;
            W[n] = W[n] + 1.0;
        }
        for (i2 = 0; i2 < W.length; ++i2) {
            if (!(W[i2] > 0.0)) continue;
            W[i2] = (double)A.length / W[i2];
        }
        double Wtotal = 0.0;
        for (i = 0; i < A.length; ++i) {
            bin = (int)(A[i][0] * (double)W.length);
            if (bin == W.length) {
                --bin;
            }
            a += W[bin] * A[i][0];
            b += W[bin] * A[i][1];
            Wtotal += W[bin];
        }
        a /= Wtotal;
        b /= Wtotal;
        for (i = 0; i < A.length; ++i) {
            bin = (int)(A[i][0] * (double)W.length);
            if (bin == W.length) {
                --bin;
            }
            aa += W[bin] * (A[i][0] - a) * (A[i][0] - a);
            ab += W[bin] * (A[i][0] - a) * (A[i][1] - b);
            bb += W[bin] * (A[i][1] - b) * (A[i][1] - b);
        }
        ab /= Wtotal;
        if ((bb /= Wtotal) == 0.0 || (aa /= Wtotal) == 0.0) {
            System.out.println("error!");
        }
        c = Math.abs(a - ab / bb * b);
        d = Math.abs(ab / bb - 1.0);
        System.gc();
        return ab / aa / bb * ab * 1.0 / (1.0 + c) / (1.0 + d);
    }

    public double pdfEval(double[] D) {
        double pdf = 1.0;
        for (int i = 0; i < this.T.length; ++i) {
            if (!this.valid[i]) continue;
            double t = 0.0;
            for (int j = 0; j <= i; ++j) {
                if (!this.valid[j]) continue;
                t += this.T[i][j] * D[j];
            }
            if (!((pdf *= this.marginal[i].pdfEval(t)) < 0.0)) continue;
            System.out.println("JPDF: Failure at marginal " + i + ", parameter: " + t + "\n  Marginal: " + this.marginal[i].pdfEval(t));
        }
        if (pdf < 0.0) {
            pdf = 0.0;
        }
        return pdf;
    }

    public double cdfEval(double[] D) {
        int k;
        int i;
        double si = 0.0;
        double todo = 0.0;
        double[] sample = new double[D.length];
        boolean aceptar = true;
        for (i = 0; i < 5000; ++i) {
            aceptar = true;
            for (k = 0; k < D.length; ++k) {
                sample[k] = this.min[k] + (this.max[k] - this.min[k]) * Math.random();
                aceptar = aceptar && sample[k] <= D[k];
            }
            si += aceptar ? this.pdfEval(sample) : 0.0;
            todo += this.pdfEval(sample);
        }
        for (i = 0; i < 1000; ++i) {
            aceptar = true;
            for (k = 0; k < D.length; ++k) {
                sample[k] = this.min[k] - (this.max[k] - this.min[k]) / 2.0 + 2.0 * (this.max[k] - this.min[k]) * Math.random();
                aceptar = aceptar && sample[k] <= D[k];
            }
            si += aceptar ? this.pdfEval(sample) : 0.0;
            todo += this.pdfEval(sample);
        }
        if (todo == 0.0) {
            return 0.0;
        }
        return si / todo;
    }

    public String toString() {
        int i;
        String s = "Joint probability density function:\n F(X1, ... ,X" + this.T.length + ")" + " = f1(T1) ... f" + this.T.length + "(T" + this.T.length + ")\n";
        s = s + "\nTransformations:\n";
        for (i = 0; i < this.T.length; ++i) {
            int j;
            boolean plus = false;
            if (this.valid[i]) {
                s = s + " T" + (i + 1) + " = ";
                for (j = 0; j <= i; ++j) {
                    if (!this.valid[j] || this.T[i][j] == 0.0) continue;
                    s = s + (plus ? " + " : "") + JointPDF.shortDouble(this.T[i][j]) + " X" + (j + 1);
                    plus = true;
                }
                s = s + " \n";
                continue;
            }
            s = s + "  X" + (i + 1) + " = ";
            for (j = 0; j <= i; ++j) {
                if (!this.valid[j] || this.T[i][j] == 0.0) continue;
                s = s + (plus ? " + " : "") + JointPDF.shortDouble(-this.T[i][j]) + " X" + (j + 1);
                plus = true;
            }
            s = s + " \n";
        }
        s = s + "\nInternal functions: f1, ... ,f" + this.T.length + "\n";
        for (i = 0; i < this.T.length; ++i) {
            s = this.valid[i] ? s + " f" + (i + 1) + ": " + this.marginal[i] + "\n" : s + " f" + (i + 1) + " = 1 (ignored due to functional dependency)\n";
        }
        s = s + "\nOverall fitness: " + this.quality + "\n";
        return s;
    }

    public static double shortDouble(double x) {
        return (double)Math.round(x * 1000000.0) / 1000000.0;
    }

    private void _fit2data(double[][] X) {
        int k;
        int i;
        double[][] Y = X.length > X[0].length ? this._transpose(X) : this._arrayclone(X);
        int M = Y[0].length;
        int N = Y.length;
        double[] V = new double[N];
        this.valid = new boolean[N];
        for (i = 0; i < N; ++i) {
            this.valid[i] = true;
        }
        this.T = new double[N][N];
        for (i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                this.T[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        for (k = 1; k < N; ++k) {
            double oldvar = this.variance(Y[k]);
            for (int i2 = 0; i2 < k; ++i2) {
                int j;
                if (!this.valid[i2]) continue;
                V[i2] = this._coef(Y[k], Y[i2]);
                for (j = 0; j < M; ++j) {
                    double[] dArray = Y[k];
                    int n = j;
                    dArray[n] = dArray[n] - V[i2] * Y[i2][j];
                }
                for (j = 0; j < k; ++j) {
                    if (!this.valid[j]) continue;
                    double[] dArray = this.T[k];
                    int n = j;
                    dArray[n] = dArray[n] - V[i2] * this.T[i2][j];
                }
            }
            double newvar = this.variance(Y[k]);
            this.valid[k] = newvar > 0.075 * oldvar;
        }
        this.marginal = new PDFType[N];
        for (k = 0; k < N; ++k) {
            this.marginal[k] = PDFType.autoFit(Y[k]);
        }
    }

    private double variance(double[] V) {
        int i;
        double var = 0.0;
        double avg = 0.0;
        for (i = 0; i < V.length; ++i) {
            avg += V[i];
        }
        avg /= (double)V.length;
        for (i = 0; i < V.length; ++i) {
            var += (V[i] - avg) * (V[i] - avg);
        }
        return var /= (double)(V.length - 1);
    }

    private double[][] _transpose(double[][] X) {
        double[][] Y = new double[X[0].length][X.length];
        for (int i = 0; i < X.length; ++i) {
            for (int j = 0; j < X[0].length; ++j) {
                Y[j][i] = X[i][j];
            }
        }
        return Y;
    }

    private double[][] _arrayclone(double[][] X) {
        double[][] Y = new double[X.length][X[0].length];
        for (int i = 0; i < X.length; ++i) {
            for (int j = 0; j < X[0].length; ++j) {
                Y[i][j] = X[i][j];
            }
        }
        return Y;
    }

    private double _coef(double[] A, double[] B) {
        double sa = 0.0;
        double sb = 0.0;
        double sab = 0.0;
        double sbb = 0.0;
        double saa = 0.0;
        for (int i = 0; i < A.length; ++i) {
            sa += A[i];
            sb += B[i];
            sab += A[i] * B[i];
            sbb += B[i] * B[i];
            saa += A[i] * A[i];
        }
        double q1 = (double)A.length * sab - sa * sb;
        double q2 = (double)A.length * sbb - sb * sb;
        double q3 = (double)A.length * saa - sa * sa;
        if (q1 * q1 / q2 / q3 < 0.02) {
            return 0.0;
        }
        if (q1 * q1 / q2 / q3 > 0.98) {
            return Math.sqrt(q3 / q2);
        }
        return q1 / q2;
    }
}

