/*
 * Decompiled with CFR 0.152.
 */
package netobs;

public class Grafo {
    private String[] campos;
    private double[][] nodos;
    private double[][] arcos;
    private int num_nodos = 0;
    private int num_arcos = 0;
    private static String[] sorts = new String[]{"Sort plot", "Strict-sort plot", "Metric plot", "Log/log plot"};

    public Grafo(String[] campos) {
        this.campos = new String[campos.length + 3];
        for (int i = 0; i < campos.length; ++i) {
            this.campos[i] = campos[i];
        }
        this.campos[campos.length] = "InDegree";
        this.campos[campos.length + 1] = "OutDegree";
        this.campos[campos.length + 2] = "TotalDegree";
        this.nodos = new double[100][campos.length + 3];
        this.arcos = new double[100][2];
    }

    public void addNodo(double[] nodo) {
        ++this.num_nodos;
        if (this.num_nodos - 1 == this.nodos.length) {
            int i;
            double[][] nvalores = new double[this.num_nodos + 100][this.campos.length + 2];
            for (i = 0; i < nodo.length; ++i) {
                nvalores[this.num_nodos - 1][i] = nodo[i];
            }
            for (i = nodo.length; i < this.campos.length; ++i) {
                nvalores[this.num_nodos - 1][i] = 0.0;
            }
            for (i = 0; i < this.num_nodos - 1; ++i) {
                nvalores[i] = (double[])this.nodos[i].clone();
            }
            this.nodos = nvalores;
        } else {
            int i;
            for (i = 0; i < nodo.length; ++i) {
                this.nodos[this.num_nodos - 1][i] = nodo[i];
            }
            for (i = nodo.length; i < this.campos.length; ++i) {
                this.nodos[this.num_nodos - 1][i] = 0.0;
            }
        }
    }

    public void addArco(double[] arco) {
        int i;
        ++this.num_arcos;
        if (this.num_arcos - 1 == this.arcos.length) {
            double[][] nvalores = new double[this.num_arcos + 100][2];
            nvalores[this.num_arcos - 1] = (double[])arco.clone();
            for (i = 0; i < this.num_arcos - 1; ++i) {
                nvalores[i] = (double[])this.arcos[i].clone();
            }
            this.arcos = nvalores;
        } else {
            this.arcos[this.num_arcos - 1] = (double[])arco.clone();
        }
        int find = 0;
        for (i = 0; i < this.num_nodos && find < 2; ++i) {
            if (this.nodos[i][0] == arco[0]) {
                double[] dArray = this.nodos[i];
                int n = this.campos.length - 2;
                dArray[n] = dArray[n] + 1.0;
                double[] dArray2 = this.nodos[i];
                int n2 = this.campos.length - 1;
                dArray2[n2] = dArray2[n2] + 1.0;
                ++find;
                continue;
            }
            if (this.nodos[i][0] != arco[1]) continue;
            double[] dArray = this.nodos[i];
            int n = this.campos.length - 3;
            dArray[n] = dArray[n] + 1.0;
            double[] dArray3 = this.nodos[i];
            int n3 = this.campos.length - 1;
            dArray3[n3] = dArray3[n3] + 1.0;
            ++find;
        }
    }

    public double[] getNodo(double key) {
        double[] resp = new double[this.campos.length];
        return resp;
    }

    public double[][] getNodos() {
        double[][] resp = new double[this.num_nodos][this.campos.length];
        for (int i = 0; i < this.num_nodos; ++i) {
            resp[i] = (double[])this.nodos[i].clone();
        }
        return resp;
    }

    public double[][] getArcos() {
        double[][] resp = new double[this.num_arcos][2];
        for (int i = 0; i < this.num_arcos; ++i) {
            resp[i] = (double[])this.arcos[i].clone();
        }
        return resp;
    }

    public String[] getCampos() {
        return this.campos;
    }

    public int length() {
        return this.num_nodos;
    }

    public static String[] getIndexingOptions() {
        return sorts;
    }

    public double[][] indexActors(int atributo, int opcion) {
        int i;
        double[][] resp = new double[this.num_nodos][3];
        for (int i2 = 0; i2 < this.num_nodos; ++i2) {
            resp[i2][0] = this.nodos[i2][0];
            resp[i2][1] = this.nodos[i2][atributo];
            resp[i2][2] = 0.0;
        }
        double dmax = Math.abs(resp[0][1]);
        for (i = 1; i < resp.length; ++i) {
            if (!(Math.abs(resp[i][1]) > dmax)) continue;
            dmax = Math.abs(resp[i][1]);
        }
        switch (opcion) {
            case 0: {
                this.secondSort(resp);
                for (i = 0; i < resp.length; ++i) {
                    resp[i][2] = (double)i / ((double)resp.length - 1.0);
                }
                break;
            }
            case 1: {
                int i3;
                this.secondSort(resp);
                int j = 0;
                resp[0][2] = 0.0;
                for (i3 = 1; i3 < resp.length; ++i3) {
                    if (resp[i3][1] != resp[i3 - 1][1]) {
                        ++j;
                    }
                    resp[i3][2] = j;
                }
                for (i3 = 0; i3 < resp.length; ++i3) {
                    resp[i3][2] = (resp[i3][2] + 0.0) / (double)j;
                }
                break;
            }
            case 2: {
                int i4;
                double min = resp[0][1];
                double max = resp[0][1];
                for (i4 = 1; i4 < resp.length; ++i4) {
                    if (resp[i4][1] > max) {
                        max = resp[i4][1];
                    }
                    if (!(resp[i4][1] < min)) continue;
                    min = resp[i4][1];
                }
                for (i4 = 0; i4 < resp.length; ++i4) {
                    resp[i4][2] = max > min ? (resp[i4][1] - min) / (max - min) : 0.5;
                }
                break;
            }
            case 3: {
                int i5;
                double min = resp[0][1];
                double max = resp[0][1];
                for (i5 = 0; i5 < resp.length; ++i5) {
                    if (resp[i5][1] > max) {
                        max = resp[i5][1];
                    }
                    if (resp[i5][1] < min) {
                        min = resp[i5][1];
                    }
                    resp[i5][2] = Math.log(1.0 + Math.abs(resp[i5][1] * 1000000.0 / dmax));
                    if (!(resp[i5][1] < 0.0)) continue;
                    resp[i5][2] = -resp[i5][2];
                }
                min = min < 0.0 ? -Math.log(1.0 + Math.abs(min * 1000000.0 / dmax)) : Math.log(1.0 + Math.abs(min * 1000000.0 / dmax));
                max = max < 0.0 ? -Math.log(1.0 + Math.abs(max * 1000000.0 / dmax)) : Math.log(1.0 + Math.abs(max * 1000000.0 / dmax));
                for (i5 = 0; i5 < resp.length; ++i5) {
                    resp[i5][2] = max > min ? (resp[i5][2] - min) / (max - min) : 0.5;
                }
                break;
            }
        }
        this.firstSort(resp);
        return resp;
    }

    private void secondSort(double[][] elems) {
        for (int i = 0; i < elems.length; ++i) {
            for (int j = 1; j < elems.length - i; ++j) {
                if (!(elems[j - 1][1] > elems[j][1])) continue;
                double key = elems[j][0];
                double atr = elems[j][1];
                double trd = elems[j][2];
                elems[j][0] = elems[j - 1][0];
                elems[j][1] = elems[j - 1][1];
                elems[j][2] = elems[j - 1][2];
                elems[j - 1][0] = key;
                elems[j - 1][1] = atr;
                elems[j - 1][2] = trd;
            }
        }
    }

    private void firstSort(double[][] elems) {
        for (int i = 0; i < elems.length; ++i) {
            for (int j = 1; j < elems.length - i; ++j) {
                if (!(elems[j - 1][0] > elems[j][0])) continue;
                double key = elems[j][0];
                double atr = elems[j][1];
                double trd = elems[j][2];
                elems[j][0] = elems[j - 1][0];
                elems[j][1] = elems[j - 1][1];
                elems[j][2] = elems[j - 1][2];
                elems[j - 1][0] = key;
                elems[j - 1][1] = atr;
                elems[j - 1][2] = trd;
            }
        }
    }
}

