/*
 * Decompiled with CFR 0.152.
 */
package netobs;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import netobs.Grafo;
import netobs.GraphSTDIN;
import netobs.GraphViewer;
import netobs.HistoViewer;
import org.jdesktop.layout.GroupLayout;

public class IngresoDatos
extends JFrame {
    JFileChooser jfc = null;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTextArea jTextArea1;
    private Label label1;

    public IngresoDatos() {
        this.initComponents();
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.label1 = new Label();
        this.jButton3 = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setDefaultCloseOperation(3);
        this.setTitle("NetObs: choose the data source");
        this.setBackground(new Color(255, 255, 255));
        this.jButton1.setText("Enter the graph by filling a form");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IngresoDatos.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Open a single file");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IngresoDatos.this.jButton2ActionPerformed(evt);
            }
        });
        this.label1.setText("Choose the source of data");
        this.jButton3.setText("Open multiple CSV files");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IngresoDatos.this.jButton3ActionPerformed(evt);
            }
        });
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("NetObs: NETWORK OBSERVER\nCreated by Mauricio Monsalve Moreno, mnmonsal@dcc.uchile.cl\n\nTool for the visualization of arc properties in networks.\nFor each network displays the Graph Viewer and the\nHistogram Viewer.\nThe Graph Viewer lets you select two attributes of the\nnodes and perform a quick research about the geometry\nof the arcs in the network.\nThe Histogram Viewer lets you research the frequency\nof the arcs between the attributes of their starting and\nending nodes.\n\nA simple CSV file might have the following format:\n* id, attrib1, attrib2\n1, 100, 200\n2, 200, 500\n5, 100, 250\n*Arcs\n1, 5\n5, 2\n\nMultiple CSV files lets you split the above CSV\nsheet in two parts. The headings are optional\nfor the second file.");
        this.jScrollPane1.setViewportView(this.jTextArea1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(1, this.jScrollPane1, -1, 467, Short.MAX_VALUE).add(1, this.jSeparator1, -1, 467, Short.MAX_VALUE).add(1, this.jButton3, -1, 467, Short.MAX_VALUE).add(1, this.jButton2, -1, 467, Short.MAX_VALUE).add(this.jButton1, -1, 467, Short.MAX_VALUE).add(1, this.label1, -2, -1, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(this.jScrollPane1, -1, 113, Short.MAX_VALUE).add(18, 18, 18).add(this.jSeparator1, -2, -1, -2).addPreferredGap(0).add(this.label1, -2, -1, -2).addPreferredGap(0).add(this.jButton1).add(18, 18, 18).add(this.jButton2, -2, 25, -2).add(18, 18, 18).add(this.jButton3).add(65, 65, 65)));
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (this.jfc == null) {
            this.jfc = new JFileChooser();
        }
        this.jfc.setDialogTitle("Open single network file");
        int returnVal = this.jfc.showOpenDialog(this);
        if (returnVal == 0) {
            BufferedReader fr;
            System.out.println("You chose to open this file: " + this.jfc.getSelectedFile().getAbsolutePath());
            try {
                fr = new BufferedReader(new FileReader(this.jfc.getSelectedFile().getAbsolutePath()));
            }
            catch (Exception e) {
                return;
            }
            String linea = "";
            try {
                linea = fr.readLine();
            }
            catch (Exception e) {
                return;
            }
            linea = linea.substring(2);
            String[] fields = linea.replaceAll("[, |\t]+", " ").split(" ");
            Grafo GR = new Grafo(fields);
            boolean open = true;
            while (open) {
                try {
                    linea = fr.readLine().trim();
                }
                catch (Exception e) {
                    open = false;
                }
                if ((linea = linea.trim()).length() == 0) continue;
                if (linea.charAt(0) == '*') break;
                double[] this_node = new double[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    this_node[i] = 0.0;
                }
                String[] this_node_str = linea.replaceAll("[ ,|\t]+", " ").trim().split(" ");
                if (this_node_str.length <= 1 && this_node_str.length < this_node.length) continue;
                for (int i = 0; i < this_node_str.length; ++i) {
                    this_node[i] = Double.parseDouble(this_node_str[i]);
                }
                GR.addNodo(this_node);
            }
            while (open) {
                linea = "";
                try {
                    linea = fr.readLine().trim();
                }
                catch (Exception e) {
                    open = false;
                }
                linea = linea.trim();
                if (linea.length() == 0) continue;
                String[] this_arc = linea.replaceAll("[ ,|\t]+", " ").trim().split(" ");
                double[] arco = new double[]{Double.parseDouble(this_arc[0]), Double.parseDouble(this_arc[1])};
                GR.addArco(arco);
            }
            HistoViewer h = new HistoViewer(GR);
            Thread tj = new Thread(h);
            h.setSize(500, 500);
            h.setVisible(true);
            tj.start();
            GraphViewer v = new GraphViewer(GR);
            Thread th = new Thread(v);
            v.setSize(600, 500);
            v.setVisible(true);
            th.start();
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        GraphSTDIN g = new GraphSTDIN();
        g.setVisible(true);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        if (this.jfc == null) {
            this.jfc = new JFileChooser();
        }
        this.jfc.setDialogTitle("Open a CSV sheet with nodes");
        int returnVal = this.jfc.showOpenDialog(this);
        if (returnVal == 0) {
            BufferedReader fr;
            System.out.println("You chose to open this file: " + this.jfc.getSelectedFile().getAbsolutePath());
            try {
                fr = new BufferedReader(new FileReader(this.jfc.getSelectedFile().getAbsolutePath()));
            }
            catch (Exception e) {
                return;
            }
            String linea = "";
            try {
                linea = fr.readLine();
            }
            catch (Exception e) {
                return;
            }
            String[] fields = linea.replaceAll("['\"]", "").replaceAll("[,; |\t]+", " ").split(" ");
            Grafo GR = new Grafo(fields);
            boolean open = true;
            while (open) {
                try {
                    linea = fr.readLine().trim();
                }
                catch (Exception e) {
                    open = false;
                }
                linea = linea.trim();
                if (linea.length() == 0) continue;
                double[] this_node = new double[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    this_node[i] = 0.0;
                }
                String[] this_node_str = linea.replaceAll("[ ,;|\t]+", " ").trim().split(" ");
                if (this_node_str.length <= 1 && this_node_str.length < this_node.length) continue;
                for (int i = 0; i < this_node_str.length; ++i) {
                    this_node[i] = Double.parseDouble(this_node_str[i]);
                }
                GR.addNodo(this_node);
            }
            try {
                fr.close();
            }
            catch (Exception e) {
                System.out.println("Problem closing the file " + this.jfc.getSelectedFile().getAbsolutePath());
            }
            try {
                Thread.sleep(250L);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.jfc.setDialogTitle("Open a CSV sheet with links");
            returnVal = this.jfc.showOpenDialog(this);
            if (returnVal == 0) {
                System.out.println("You chose to open this file: " + this.jfc.getSelectedFile().getAbsolutePath());
                try {
                    fr = new BufferedReader(new FileReader(this.jfc.getSelectedFile().getAbsolutePath()));
                }
                catch (Exception e) {
                    return;
                }
                open = true;
                while (open) {
                    linea = "";
                    try {
                        linea = fr.readLine().trim();
                    }
                    catch (Exception e) {
                        open = false;
                    }
                    if ((linea = linea.trim()).length() == 0 || !linea.matches("-?[0-9\\.]+[ \t,;|]+-?[0-9\\.]+")) continue;
                    String[] this_arc = linea.replaceAll("[ ,;|\t]+", " ").trim().split(" ");
                    double[] arco = new double[]{Double.parseDouble(this_arc[0]), Double.parseDouble(this_arc[1])};
                    GR.addArco(arco);
                }
                try {
                    fr.close();
                }
                catch (Exception e) {
                    System.out.println("Problem closing the file " + this.jfc.getSelectedFile().getAbsolutePath());
                }
                HistoViewer h = new HistoViewer(GR);
                Thread tj = new Thread(h);
                h.setSize(500, 500);
                h.setVisible(true);
                tj.start();
                GraphViewer v = new GraphViewer(GR);
                Thread th = new Thread(v);
                v.setSize(600, 500);
                v.setVisible(true);
                th.start();
            } else {
                GR = null;
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new IngresoDatos().setVisible(true);
            }
        });
    }
}

