/*
 * Decompiled with CFR 0.152.
 */
package netobs;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JFrame;
import netobs.Grafo;

public class HistoViewer
extends JFrame
implements Runnable {
    private int ancho;
    private int alto;
    private Graphics G = null;
    private int click = 0;
    private int x = 0;
    private int y = 0;
    private int pressed = 0;
    private Grafo GR;
    private int[][] HISTO;
    private int[] XISTO;
    private int[] YISTO;
    private String[] labelsX1;
    private String[] labelsY1;
    private String[] labelsX2;
    private String[] labelsY2;
    private int maxVal = 1;
    private int scaleX = 0;
    private int scaleY = 0;
    private int style = 0;
    private int transf = 0;
    private int ratio = 0;
    private int resolucionH = 8;
    private int redraw = 0;
    private Canvas VisorCanvas;

    private void initComponents() {
        this.VisorCanvas = new Canvas();
        this.setDefaultCloseOperation(2);
        this.setTitle("NetObs: Histogram Viewer");
        this.setBackground(new Color(255, 255, 255));
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                HistoViewer.this.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                HistoViewer.this.formFocusGained(evt);
            }
        });
        this.getContentPane().setLayout(new GridLayout(1, 0));
        this.VisorCanvas.setBackground(new Color(255, 255, 255));
        this.VisorCanvas.setFont(new Font("Dialog", 0, 10));
        this.VisorCanvas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                HistoViewer.this.VisorCanvasMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                HistoViewer.this.VisorCanvasMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                HistoViewer.this.VisorCanvasMouseReleased(evt);
            }
        });
        this.VisorCanvas.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                HistoViewer.this.VisorCanvasComponentResized(evt);
            }
        });
        this.VisorCanvas.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                HistoViewer.this.VisorCanvasMouseDragged(evt);
            }
        });
        this.getContentPane().add(this.VisorCanvas);
        this.pack();
    }

    private void formFocusGained(FocusEvent evt) {
        this.click = -1;
    }

    private void VisorCanvasMousePressed(MouseEvent evt) {
        this.pressed = 1;
        this.x = evt.getX();
        this.y = evt.getY();
        this.click = 1 == evt.getButton() ? 1 : 2;
    }

    private void VisorCanvasMouseReleased(MouseEvent evt) {
        this.pressed = 0;
        this.x = evt.getX();
        this.y = evt.getY();
    }

    private void VisorCanvasMouseDragged(MouseEvent evt) {
        this.pressed = 1;
        this.x = evt.getX();
        this.y = evt.getY();
    }

    private void VisorCanvasMouseClicked(MouseEvent evt) {
    }

    private void VisorCanvasComponentResized(ComponentEvent evt) {
        this.ancho = this.VisorCanvas.getWidth();
        this.alto = this.VisorCanvas.getHeight();
        this.prepararHistograma();
        this.click = -1;
    }

    private void formWindowGainedFocus(WindowEvent evt) {
        this.click = -1;
    }

    public HistoViewer(Grafo gr) {
        this.GR = gr;
        this.HISTO = new int[20][20];
        this.XISTO = new int[20];
        this.YISTO = new int[20];
        this.labelsX1 = new String[20];
        this.labelsY1 = new String[20];
        this.labelsX2 = new String[20];
        this.labelsY2 = new String[20];
        this.initComponents();
    }

    @Override
    public void run() {
        this.ancho = this.VisorCanvas.getWidth();
        this.alto = this.VisorCanvas.getHeight();
        this.G = this.VisorCanvas.getGraphics();
        this.prepararHistograma();
        this.pausa(200);
        this.G.setColor(new Color(0xFFFFFF));
        this.G.fillRect(0, 0, this.ancho, this.alto);
        this.dibujarMarco();
        this.dibujarHistograma();
        block0: while (true) {
            if (this.click > 0 && this.cambiarPropiedades()) {
                this.pressed = 0;
            }
            this.G.setColor(new Color(0xFFFFFF));
            this.G.fillRect(0, 0, this.ancho, this.alto);
            this.G.setFont(new Font("Arial", 0, 12));
            this.dibujarMarco();
            this.dibujarHistograma();
            this.click = 0;
            this.redraw = 0;
            this.pausa(100);
            while (true) {
                if (this.click != 0 || this.pressed != 0) continue block0;
                this.pausa(25);
            }
            break;
        }
    }

    private boolean cambiarPropiedades() {
        int maximo;
        boolean resp = false;
        int dx = Math.min(this.ancho, this.alto) / (this.resolucionH + 3);
        int fs = this.G.getFont().getSize();
        int bborde = Math.min(this.ancho, this.alto) - 162;
        if (85 < this.x && this.x < 165 && 2 < this.y && this.y < fs + 4) {
            maximo = this.GR.getCampos().length;
            this.scaleY = this.click == 1 ? ++this.scaleY : --this.scaleY;
            if (this.scaleY == maximo) {
                this.scaleY = 0;
            }
            if (this.scaleY < 0) {
                this.scaleY = maximo - 1;
            }
            this.prepararHistograma();
            resp = true;
        }
        if (5 < this.x && this.x < 85 && dx < this.y && this.y < dx + fs + 2) {
            maximo = this.GR.getCampos().length;
            this.scaleX = this.click == 1 ? ++this.scaleX : --this.scaleX;
            if (this.scaleX == maximo) {
                this.scaleX = 0;
            }
            if (this.scaleX < 0) {
                this.scaleX = maximo - 1;
            }
            this.prepararHistograma();
            resp = true;
        }
        if (bborde < this.x && this.x < bborde + 80 && this.alto - fs - 4 < this.y && this.y < this.alto - 2) {
            maximo = 4;
            this.style = this.click == 1 ? ++this.style : --this.style;
            if (this.style == maximo) {
                this.style = 0;
            }
            if (this.style < 0) {
                this.style = maximo - 1;
            }
            this.prepararHistograma();
            resp = true;
        }
        if (bborde - 80 < this.x && this.x < bborde && this.alto - fs - 4 < this.y && this.y < this.alto - 2) {
            maximo = 4;
            this.ratio = this.click == 1 ? ++this.ratio : --this.ratio;
            if (this.ratio == maximo) {
                this.ratio = 0;
            }
            if (this.ratio < 0) {
                this.ratio = maximo - 1;
            }
            this.prepararHistograma();
            resp = true;
        }
        if (bborde - 160 < this.x && this.x < bborde - 80 && this.alto - fs - 4 < this.y && this.y < this.alto - 2) {
            maximo = 8;
            this.transf = this.click == 1 ? ++this.transf : --this.transf;
            if (this.transf == maximo) {
                this.transf = 0;
            }
            if (this.transf < 0) {
                this.transf = maximo - 1;
            }
            this.prepararHistograma();
            resp = true;
        }
        if (bborde + 80 < this.x && this.x < bborde + 160 && this.alto - fs - 4 < this.y && this.y < this.alto - 2) {
            this.resolucionH = this.click == 1 ? ++this.resolucionH : --this.resolucionH;
            if (this.resolucionH > 16) {
                this.resolucionH = 6;
            }
            if (this.resolucionH < 6) {
                this.resolucionH = 16;
            }
            this.prepararHistograma();
            resp = true;
        }
        return resp;
    }

    private void dibujarMarco() {
        if (this.G == null) {
            return;
        }
        int dx = Math.min(this.ancho, this.alto) / (this.resolucionH + 3);
        int fs = this.G.getFont().getSize();
        int bborde = Math.min(this.ancho, this.alto) - 162;
        String[] modo = new String[]{"Squares", "Bars", "Grayscale", "Frequency"};
        String[] stats = new String[]{"Absolute", "Density", "<OutDeg>", "<InDeg>"};
        String[] applic = new String[]{"Identity", "[-]lg(1+|x|)", "exp(x)", "x ^ (1/3)", "x ^ (1/5)", "x ^ (3/5)", "x ^ (5/3)", "x ^ 3"};
        String[] campo = this.GR.getCampos();
        this.G.setColor(new Color(26180));
        this.G.drawLine(45, dx, 125, fs + 6);
        this.G.fillArc(115, fs + 6 - 10, 20, 20, 180, 60);
        this.G.setColor(new Color(0xDDDDDD));
        this.G.fillRect(85, 2, 80, fs + 2);
        this.G.fillRect(5, dx, 80, fs + 2);
        this.G.setColor(new Color(0xAAAAAA));
        this.G.drawRect(85, 2, 80, fs + 2);
        this.G.drawRect(5, dx, 80, fs + 2);
        this.G.setColor(new Color(0));
        this.G.drawString(campo[this.scaleY], 88, fs + 1);
        this.G.drawString(campo[this.scaleX], 8, dx + fs + 1);
        this.G.setColor(new Color(0xDDDDDD));
        this.G.fillRect(bborde, this.alto - fs - 4, 80, fs + 2);
        this.G.setColor(new Color(0xAAAAAA));
        this.G.drawRect(bborde, this.alto - fs - 4, 80, fs + 2);
        this.G.setColor(new Color(0));
        this.G.drawString(modo[this.style], bborde + 2, this.alto - 4);
        this.G.setColor(new Color(0xDDDDDD));
        this.G.fillRect(bborde - 80, this.alto - fs - 4, 80, fs + 2);
        this.G.setColor(new Color(0xAAAAAA));
        this.G.drawRect(bborde - 80, this.alto - fs - 4, 80, fs + 2);
        if (this.style != 3) {
            this.G.setColor(new Color(0));
        }
        this.G.drawString(stats[this.ratio], bborde + 2 - 80, this.alto - 4);
        this.G.setColor(new Color(0xDDDDDD));
        this.G.fillRect(bborde - 160, this.alto - fs - 4, 80, fs + 2);
        this.G.setColor(new Color(0xAAAAAA));
        this.G.drawRect(bborde - 160, this.alto - fs - 4, 80, fs + 2);
        this.G.setColor(new Color(0));
        this.G.drawString(applic[this.transf], bborde + 2 - 160, this.alto - 4);
        this.G.setColor(new Color(0xDDDDDD));
        this.G.fillRect(bborde + 80, this.alto - fs - 4, 80, fs + 2);
        this.G.setColor(new Color(0xAAAAAA));
        this.G.drawRect(bborde + 80, this.alto - fs - 4, 80, fs + 2);
        this.G.setColor(new Color(0));
        this.G.drawString(this.resolucionH + "x" + this.resolucionH, bborde + 82, this.alto - 4);
    }

    private void prepararHistograma() {
        int v;
        int u;
        double min2;
        double min1;
        int j;
        int i;
        int i2;
        double[][] nds1 = this.GR.indexActors(this.scaleX, 1);
        double[][] nds2 = this.GR.indexActors(this.scaleY, 1);
        double[][] links = this.GR.getArcos();
        int numlinks = 0;
        if (this.transf == 1) {
            for (i2 = 0; i2 < nds1.length; ++i2) {
                nds1[i2][1] = (double)(nds1[i2][1] < 0.0 ? -1 : 1) * Math.log(1.0 + Math.abs(nds1[i2][1]));
                nds2[i2][1] = (double)(nds2[i2][1] < 0.0 ? -1 : 1) * Math.log(1.0 + Math.abs(nds2[i2][1]));
            }
        }
        if (this.transf == 2) {
            for (i2 = 0; i2 < nds1.length; ++i2) {
                nds1[i2][1] = (double)(nds1[i2][1] < 0.0 ? -1 : 1) * Math.exp(nds1[i2][1]);
                nds2[i2][1] = (double)(nds2[i2][1] < 0.0 ? -1 : 1) * Math.exp(nds2[i2][1]);
            }
        }
        if (this.transf == 3) {
            for (i2 = 0; i2 < nds1.length; ++i2) {
                nds1[i2][1] = (double)(nds1[i2][1] < 0.0 ? -1 : 1) * Math.pow(Math.abs(nds1[i2][1]), 0.3333333333333333);
                nds2[i2][1] = (double)(nds2[i2][1] < 0.0 ? -1 : 1) * Math.pow(Math.abs(nds2[i2][1]), 0.3333333333333333);
            }
        }
        if (this.transf == 4) {
            for (i2 = 0; i2 < nds1.length; ++i2) {
                nds1[i2][1] = (double)(nds1[i2][1] < 0.0 ? -1 : 1) * Math.pow(Math.abs(nds1[i2][1]), 0.2);
                nds2[i2][1] = (double)(nds2[i2][1] < 0.0 ? -1 : 1) * Math.pow(Math.abs(nds2[i2][1]), 0.2);
            }
        }
        if (this.transf == 5) {
            for (i2 = 0; i2 < nds1.length; ++i2) {
                nds1[i2][1] = (double)(nds1[i2][1] < 0.0 ? -1 : 1) * Math.pow(Math.abs(nds1[i2][1]), 0.6);
                nds2[i2][1] = (double)(nds2[i2][1] < 0.0 ? -1 : 1) * Math.pow(Math.abs(nds2[i2][1]), 0.6);
            }
        }
        if (this.transf == 7) {
            for (i2 = 0; i2 < nds1.length; ++i2) {
                nds1[i2][1] = (double)(nds1[i2][1] < 0.0 ? -1 : 1) * Math.pow(Math.abs(nds1[i2][1]), 3.0);
                nds2[i2][1] = (double)(nds2[i2][1] < 0.0 ? -1 : 1) * Math.pow(Math.abs(nds2[i2][1]), 3.0);
            }
        }
        if (this.transf == 8) {
            for (i2 = 0; i2 < nds1.length; ++i2) {
                nds1[i2][1] = (double)(nds1[i2][1] < 0.0 ? -1 : 1) * Math.pow(Math.abs(nds1[i2][1]), 1.6666666666666667);
                nds2[i2][1] = (double)(nds2[i2][1] < 0.0 ? -1 : 1) * Math.pow(Math.abs(nds2[i2][1]), 1.6666666666666667);
            }
        }
        double[][] hlinks = new double[links.length][2];
        boolean found = false;
        for (i = 0; i < links.length; ++i) {
            found = false;
            for (j = 0; j < nds1.length; ++j) {
                if (links[i][0] != nds1[j][0]) continue;
                found = true;
                hlinks[numlinks][0] = nds1[j][1];
            }
            if (!found) continue;
            found = false;
            for (j = 0; j < nds2.length; ++j) {
                if (links[i][1] != nds2[j][0]) continue;
                found = true;
                hlinks[numlinks][1] = nds2[j][1];
            }
            if (!found) continue;
            ++numlinks;
        }
        double max1 = min1 = hlinks[0][0];
        double max2 = min2 = hlinks[0][1];
        for (i = 1; i < numlinks; ++i) {
            if (max1 < hlinks[i][0]) {
                max1 = hlinks[i][0];
            }
            if (min1 > hlinks[i][0]) {
                min1 = hlinks[i][0];
            }
            if (max2 < hlinks[i][1]) {
                max2 = hlinks[i][1];
            }
            if (!(min2 > hlinks[i][1])) continue;
            min2 = hlinks[i][1];
        }
        double dx1 = (max1 - min1) / (double)this.resolucionH;
        double dx2 = (max2 - min2) / (double)this.resolucionH;
        for (i = 0; i < this.resolucionH; ++i) {
            this.labelsX1[i] = "[" + this.doubleCaster(min1 + (double)i * dx1) + ",";
            this.labelsY1[i] = "[" + this.doubleCaster(min2 + (double)i * dx2) + ",";
            if (i == this.resolucionH - 1) {
                this.labelsX2[i] = this.doubleCaster(min1 + (double)i * dx1 + dx1) + "]";
                this.labelsY2[i] = this.doubleCaster(min2 + (double)i * dx2 + dx2) + "]";
                continue;
            }
            this.labelsX2[i] = this.doubleCaster(min1 + (double)i * dx1 + dx1) + "[";
            this.labelsY2[i] = this.doubleCaster(min2 + (double)i * dx2 + dx2) + "[";
        }
        for (i = 0; i < 20; ++i) {
            for (j = 0; j < 20; ++j) {
                this.HISTO[j][i] = 0;
            }
            this.XISTO[i] = 0;
            this.YISTO[i] = 0;
        }
        for (i = 0; i < numlinks; ++i) {
            u = hlinks[i][0] == max1 ? this.resolucionH - 1 : (int)((double)this.resolucionH * (hlinks[i][0] - min1) / (max1 - min1));
            v = hlinks[i][1] == max2 ? this.resolucionH - 1 : (int)((double)this.resolucionH * (hlinks[i][1] - min2) / (max2 - min2));
            int[] nArray = this.HISTO[u];
            int n = v;
            nArray[n] = nArray[n] + 1;
        }
        for (i = 0; i < nds1.length; ++i) {
            u = nds1[i][1] == max1 ? this.resolucionH - 1 : (int)((double)this.resolucionH * (nds1[i][1] - min1) / (max1 - min1));
            int n = v = nds2[i][1] == max2 ? this.resolucionH - 1 : (int)((double)this.resolucionH * (nds2[i][1] - min2) / (max2 - min2));
            if (u < 0 || u >= this.resolucionH || v < 0 || v >= this.resolucionH) continue;
            int n2 = u;
            this.XISTO[n2] = this.XISTO[n2] + 1;
            int n3 = v;
            this.YISTO[n3] = this.YISTO[n3] + 1;
        }
    }

    private void dibujarHistograma() {
        int dimens = Math.min(this.ancho, this.alto);
        int dx = dimens / (this.resolucionH + 3);
        int fs = this.G.getFont().getSize();
        this.G.setColor(new Color(0));
        double max = 0.0;
        double sum = 0.0;
        double xmax = 0.0;
        double ymax = 0.0;
        for (int i = 0; i < this.resolucionH; ++i) {
            if (xmax < (double)this.XISTO[i]) {
                xmax = this.XISTO[i];
            }
            if (ymax < (double)this.YISTO[i]) {
                ymax = this.YISTO[i];
            }
            for (int j = 0; j < this.resolucionH; ++j) {
                if (this.XISTO[i] == 0 || this.YISTO[j] == 0) continue;
                if (this.ratio == 0) {
                    sum += (double)this.HISTO[i][j];
                    if ((double)this.HISTO[i][j] > max) {
                        max = this.HISTO[i][j];
                    }
                }
                if (this.ratio == 1) {
                    sum += 1.0 * (double)this.HISTO[i][j] / (double)this.XISTO[i] / (double)this.YISTO[j];
                    if (1.0 * (double)this.HISTO[i][j] / (double)this.XISTO[i] / (double)this.YISTO[j] > max) {
                        max = 1.0 * (double)this.HISTO[i][j] / (double)this.XISTO[i] / (double)this.YISTO[j];
                    }
                }
                if (this.ratio == 2) {
                    sum += 1.0 * (double)this.HISTO[i][j] / (double)this.XISTO[i];
                    if (1.0 * (double)this.HISTO[i][j] / (double)this.XISTO[i] > max) {
                        max = 1.0 * (double)this.HISTO[i][j] / (double)this.XISTO[i];
                    }
                }
                if (this.ratio != 3) continue;
                sum += 1.0 * (double)this.HISTO[i][j] / (double)this.YISTO[j];
                if (!(1.0 * (double)this.HISTO[i][j] / (double)this.YISTO[j] > max)) continue;
                max = 1.0 * (double)this.HISTO[i][j] / (double)this.YISTO[j];
            }
        }
        this.G.setFont(new Font("Arial", 0, 10));
        boolean inter = true;
        for (int i = 0; i <= this.resolucionH; ++i) {
            this.G.setColor(new Color(0xBBBBBB));
            this.G.drawLine(3 * dx, dx + dx + i * dx, 3 * dx + this.resolucionH * dx, dx + dx + i * dx);
            this.G.drawLine(3 * dx + i * dx, dx + dx, 3 * dx + i * dx, dx + dx + this.resolucionH * dx);
            if (i >= this.resolucionH) continue;
            inter = !inter;
            this.G.setColor(new Color(inter ? 0 : 0x448866));
            this.G.drawString(this.labelsY1[i], 3 * dx + i * dx, dx + dx / 8);
            this.G.drawString(this.labelsY2[i], 3 * dx + i * dx, dx + dx / 2);
            this.G.drawString(this.labelsX1[i], dx, 2 * dx + dx / 4 + i * dx);
            this.G.drawString(this.labelsX2[i], dx, 2 * dx + dx / 2 + dx / 8 + i * dx);
        }
        double cell_ratio = 0.0;
        for (int i = 0; i < this.resolucionH; ++i) {
            for (int j = 0; j < this.resolucionH; ++j) {
                if ((this.XISTO[j] == 0 || this.YISTO[i] == 0) && this.style < 6) {
                    this.G.setColor(new Color(0x404040));
                    this.G.drawLine(3 * dx + i * dx, 2 * dx + j * dx, 4 * dx + i * dx, 3 * dx + j * dx);
                    this.G.drawLine(4 * dx + i * dx, 2 * dx + j * dx, 3 * dx + i * dx, 3 * dx + j * dx);
                    continue;
                }
                switch (this.ratio) {
                    case 1: {
                        cell_ratio = 1.0 * (double)this.HISTO[j][i] / (double)this.XISTO[j] / (double)this.YISTO[i];
                        break;
                    }
                    case 2: {
                        cell_ratio = 1.0 * (double)this.HISTO[j][i] / (double)this.XISTO[j];
                        break;
                    }
                    case 3: {
                        cell_ratio = 1.0 * (double)this.HISTO[j][i] / (double)this.YISTO[i];
                        break;
                    }
                    default: {
                        cell_ratio = this.HISTO[j][i];
                    }
                }
                if (this.style == 0) {
                    int color = 65793 * (int)(220.0 - 220.0 * Math.sqrt((double)(this.XISTO[j] * this.YISTO[i]) / xmax / ymax));
                    this.G.setColor(new Color(color));
                    double sqr = Math.sqrt(cell_ratio / max);
                    this.G.fillRect((int)((double)(3 * dx + i * dx) + ((double)dx - (double)dx * sqr) / 2.0), (int)((double)(dx + dx + j * dx) + ((double)dx - (double)dx * sqr) / 2.0), (int)((double)dx * sqr), (int)((double)dx * sqr));
                    continue;
                }
                if (this.style == 1) {
                    int color = 131072 * (int)((double)(63 * this.XISTO[j] * this.YISTO[i]) / xmax / ymax) + 258 * (int)(63.0 - (double)(63 * this.XISTO[j] * this.YISTO[i]) / xmax / ymax) + (j % 2 == 0 ? 0x104010 : 0);
                    this.G.setColor(new Color(color));
                    this.G.fillRect(3 * dx + i * dx + 1 + dx / 4, 2 * dx + j * dx + 2, dx / 2 - 2, dx - 2);
                    this.G.setColor(new Color(0xFFFFFF));
                    this.G.fillRect(3 * dx + i * dx + 1, 2 * dx + j * dx + 2, dx - 2, (int)((double)(dx - 2) * (1.0 - cell_ratio / max)));
                    continue;
                }
                if (this.style == 2) {
                    this.G.setColor(new Color(65793 * (int)(254.0 * (1.0 - cell_ratio / max))));
                    this.G.fillRect(3 * dx + i * dx + 1, dx + dx + j * dx + 1, dx - 1, dx - 1);
                    continue;
                }
                if (this.style != 3) continue;
                this.G.setFont(new Font("Arial", 0, 9));
                this.G.setColor(new Color(0));
                if (this.HISTO[j][i] == 0) {
                    this.G.setColor(new Color(0xAAAAAA));
                }
                String txt = "L=" + this.doubleCaster(this.HISTO[j][i]);
                this.G.drawString(txt, 3 * dx + i * dx + dx / 2 - dx * txt.length() / 24, (2 + j) * dx + 2 + fs);
                txt = "N=" + this.doubleCaster(this.XISTO[j]) + "x" + this.doubleCaster(this.YISTO[i]);
                this.G.drawString(txt, (3 + i) * dx + 2, (2 + j) * dx + 2 + 2 * fs);
                txt = "D=" + this.doubleCaster(1.0 * (double)this.HISTO[j][i] / (double)this.XISTO[j] / (double)this.YISTO[i]);
                this.G.drawString(txt, (3 + i) * dx + 2, (2 + j) * dx + 2 + 3 * fs);
            }
        }
    }

    private String doubleCaster(double x) {
        if (x == (double)((int)x) && x > -10000.0 && x < 10000.0) {
            return "" + (int)x;
        }
        if (Math.abs(x) < 0.01) {
            double y = Math.abs(x);
            y = (int)Math.log10(y);
            return "" + (double)((int)((x /= Math.pow(10.0, y)) * 100.0)) / 100.0 + " E" + (int)y;
        }
        if (x > -2.0 && x < 2.0) {
            return "" + (double)((int)(x * 1000.0)) / 1000.0;
        }
        if (x > -1000.0 && x < 1000.0) {
            return "" + (double)((int)(x * 100.0)) / 100.0;
        }
        if (x > 9999999.0 || x < 9999999.0) {
            double y = Math.abs(x);
            y = (int)Math.log10(y);
            return "" + (double)((int)((x /= Math.pow(10.0, y)) * 100.0)) / 100.0 + " e" + (int)y;
        }
        if (x == (double)((int)x)) {
            return "" + (int)x;
        }
        return "" + (double)((int)(x * 10.0)) / 10.0;
    }

    public void pausa(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

