/*
 * Decompiled with CFR 0.152.
 */
package netobs;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JFrame;
import netobs.Grafo;

public class GraphViewer
extends JFrame
implements Runnable {
    private int ancho;
    private int alto;
    private Graphics G = null;
    private int click = 0;
    private int x = 0;
    private int y = 0;
    private int pressed = 0;
    private Grafo GR;
    private int[][] NOD;
    private int[][] ARC;
    private int scaleX = 0;
    private int scaleY = 1;
    private int style = 1;
    private int relacionV = 0;
    private int relacionH = 0;
    private int arrowSize = 5;
    double[][] n1;
    double[][] n2;
    double h0;
    double h1;
    double h2;
    double h3;
    double h4;
    double v0;
    double v1;
    double v2;
    double v3;
    double v4;
    double xx1;
    double xx2;
    double xx3;
    double yy1;
    double yy2;
    double yy3;
    private Canvas VisorCanvas;

    private void initComponents() {
        this.VisorCanvas = new Canvas();
        this.setDefaultCloseOperation(2);
        this.setTitle("NetObs: Graph Viewer");
        this.setBackground(new Color(255, 255, 255));
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                GraphViewer.this.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                GraphViewer.this.formFocusGained(evt);
            }
        });
        this.getContentPane().setLayout(new GridLayout(1, 0));
        this.VisorCanvas.setBackground(new Color(255, 255, 255));
        this.VisorCanvas.setFont(new Font("Dialog", 0, 10));
        this.VisorCanvas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GraphViewer.this.VisorCanvasMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                GraphViewer.this.VisorCanvasMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                GraphViewer.this.VisorCanvasMouseReleased(evt);
            }
        });
        this.VisorCanvas.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                GraphViewer.this.VisorCanvasComponentResized(evt);
            }
        });
        this.VisorCanvas.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                GraphViewer.this.VisorCanvasMouseDragged(evt);
            }
        });
        this.getContentPane().add(this.VisorCanvas);
        this.pack();
    }

    private void formFocusGained(FocusEvent evt) {
        this.click = -1;
    }

    private void VisorCanvasMousePressed(MouseEvent evt) {
        this.pressed = 1;
        this.x = evt.getX();
        this.y = evt.getY();
        this.click = 1 == evt.getButton() ? 1 : 2;
    }

    private void VisorCanvasMouseReleased(MouseEvent evt) {
        this.pressed = 0;
        this.x = evt.getX();
        this.y = evt.getY();
    }

    private void VisorCanvasMouseDragged(MouseEvent evt) {
        this.pressed = 1;
        this.x = evt.getX();
        this.y = evt.getY();
    }

    private void VisorCanvasMouseClicked(MouseEvent evt) {
    }

    private void VisorCanvasComponentResized(ComponentEvent evt) {
        this.ancho = this.VisorCanvas.getWidth();
        this.alto = this.VisorCanvas.getHeight();
        this.prepararVisualizacion();
        this.click = -1;
    }

    private void formWindowGainedFocus(WindowEvent evt) {
        this.click = -1;
    }

    public GraphViewer(Grafo gr) {
        this.GR = gr;
        this.initComponents();
    }

    @Override
    public void run() {
        this.ancho = this.VisorCanvas.getWidth();
        this.alto = this.VisorCanvas.getHeight();
        this.G = this.VisorCanvas.getGraphics();
        this.G.setFont(new Font("Arial", 0, 11));
        this.prepararVisualizacion();
        this.pausa(200);
        this.G.setColor(new Color(0xFFFFFF));
        this.G.fillRect(0, 0, this.ancho, this.alto);
        this.dibujarMarco();
        block0: while (true) {
            if (this.click > 0 && this.cambiarPropiedades()) {
                this.pressed = 0;
            }
            this.G.setColor(new Color(0xFFFFFF));
            this.G.fillRect(0, 0, this.ancho, this.alto);
            this.dibujarMarco();
            this.dibujarGrafo(true);
            this.click = 0;
            this.pausa(100);
            while (true) {
                if (this.click != 0 || this.pressed != 0) continue block0;
                this.pausa(25);
            }
            break;
        }
    }

    private boolean cambiarPropiedades() {
        int maximo;
        boolean resp = false;
        if (5 < this.x && this.x < 105 && 2 < this.y && this.y < 17) {
            maximo = this.GR.getCampos().length;
            this.scaleY = this.click == 1 ? ++this.scaleY : --this.scaleY;
            if (this.scaleY == maximo) {
                this.scaleY = 0;
            }
            if (this.scaleY < 0) {
                this.scaleY = maximo - 1;
            }
            this.prepararVisualizacion();
            resp = true;
        }
        if (this.ancho - 105 < this.x && this.x < this.ancho - 5 && this.alto - 17 < this.y && this.y < this.alto - 2) {
            maximo = this.GR.getCampos().length;
            this.scaleX = this.click == 1 ? ++this.scaleX : --this.scaleX;
            if (this.scaleX == maximo) {
                this.scaleX = 0;
            }
            if (this.scaleX < 0) {
                this.scaleX = maximo - 1;
            }
            this.prepararVisualizacion();
            resp = true;
        }
        if (this.ancho / 2 < this.x && this.x < this.ancho / 2 + 100 && 2 < this.y && this.y < 17) {
            maximo = Grafo.getIndexingOptions().length;
            this.style = this.click == 1 ? ++this.style : --this.style;
            if (this.style == maximo) {
                this.style = 0;
            }
            if (this.style < 0) {
                this.style = maximo - 1;
            }
            this.prepararVisualizacion();
            resp = true;
        }
        if (this.ancho / 2 - 100 < this.x && this.x < this.ancho / 2 - 70 && 2 < this.y && this.y < 17) {
            this.relacionV = this.click == 1 ? ++this.relacionV : --this.relacionV;
            if (this.relacionV == 4) {
                this.relacionV = 0;
            }
            if (this.relacionV < 0) {
                this.relacionV = 3;
            }
        }
        if (this.ancho / 2 - 70 < this.x && this.x < this.ancho / 2 - 40 && 2 < this.y && this.y < 17) {
            this.relacionH = this.click == 1 ? ++this.relacionH : --this.relacionH;
            if (this.relacionH == 4) {
                this.relacionH = 0;
            }
            if (this.relacionH < 0) {
                this.relacionH = 3;
            }
        }
        if (this.ancho / 2 - 40 < this.x && this.x < this.ancho / 2 - 10 && 2 < this.y && this.y < 17) {
            this.arrowSize = this.click == 1 ? ++this.arrowSize : --this.arrowSize;
            if (this.arrowSize > 8) {
                this.arrowSize = 0;
            }
            if (this.arrowSize < 0) {
                this.arrowSize = 8;
            }
        }
        return resp;
    }

    private void dibujarEscalas() {
        if (this.G == null) {
            return;
        }
        double dx = this.ancho - 90;
        double dy = this.alto - 90;
        this.G.setColor(new Color(0));
        this.G.setFont(new Font("Arial", 1, 11));
        this.G.drawString(this.doubleCaster(this.v0), 5, this.alto - 56 - (int)(dy * 0.0));
        this.G.drawLine(50, this.alto - 60 - (int)(dy * 0.0), 55, this.alto - 60 - (int)(dy * 0.0));
        this.G.drawLine(50, this.alto - 61 - (int)(dy * 0.0), 55, this.alto - 61 - (int)(dy * 0.0));
        if (this.yy1 > 0.1 && this.yy2 - this.yy1 > 0.1) {
            this.G.drawString(this.doubleCaster(this.v1), 5, this.alto - 56 - (int)(dy * this.yy1));
            this.G.drawLine(50, this.alto - 60 - (int)(dy * this.yy1), 55, this.alto - 60 - (int)(dy * this.yy1));
            this.G.drawLine(50, this.alto - 61 - (int)(dy * this.yy1), 55, this.alto - 61 - (int)(dy * this.yy1));
        }
        this.G.drawString(this.doubleCaster(this.v2), 5, this.alto - 56 - (int)(dy * this.yy2));
        this.G.drawLine(50, this.alto - 60 - (int)(dy * this.yy2), 55, this.alto - 60 - (int)(dy * this.yy2));
        this.G.drawLine(50, this.alto - 61 - (int)(dy * this.yy2), 55, this.alto - 61 - (int)(dy * this.yy2));
        if (this.yy3 < 0.9 && this.yy3 - this.yy2 > 0.1) {
            this.G.drawString(this.doubleCaster(this.v3), 5, this.alto - 56 - (int)(dy * this.yy3));
            this.G.drawLine(50, this.alto - 60 - (int)(dy * this.yy3), 55, this.alto - 60 - (int)(dy * this.yy3));
            this.G.drawLine(50, this.alto - 61 - (int)(dy * this.yy3), 55, this.alto - 61 - (int)(dy * this.yy3));
        }
        this.G.drawString(this.doubleCaster(this.v4), 5, this.alto - 56 - (int)(dy * 1.0));
        this.G.drawLine(50, this.alto - 60 - (int)(dy * 1.0), 55, this.alto - 60 - (int)(dy * 1.0));
        this.G.drawLine(50, this.alto - 61 - (int)(dy * 1.0), 55, this.alto - 61 - (int)(dy * 1.0));
        this.G.drawLine(60 + (int)(dx * 0.0), this.alto - 50, 60 + (int)(dx * 0.0), this.alto - 55);
        this.G.drawLine(61 + (int)(dx * 0.0), this.alto - 50, 61 + (int)(dx * 0.0), this.alto - 55);
        this.G.drawString(this.doubleCaster(this.h0), 52 + (int)(dx * 0.0), this.alto - 35);
        if (this.xx1 > 0.1 && this.xx2 - this.xx1 > 0.1) {
            this.G.drawLine(60 + (int)(dx * this.xx1), this.alto - 50, 60 + (int)(dx * this.xx1), this.alto - 55);
            this.G.drawLine(61 + (int)(dx * this.xx1), this.alto - 50, 61 + (int)(dx * this.xx1), this.alto - 55);
            this.G.drawString(this.doubleCaster(this.h1), 52 + (int)(dx * this.xx1), this.alto - 35);
        }
        this.G.drawLine(60 + (int)(dx * this.xx2), this.alto - 50, 60 + (int)(dx * this.xx2), this.alto - 55);
        this.G.drawLine(61 + (int)(dx * this.xx2), this.alto - 50, 61 + (int)(dx * this.xx2), this.alto - 55);
        this.G.drawString(this.doubleCaster(this.h2), 52 + (int)(dx * this.xx2), this.alto - 35);
        if (this.xx3 < 0.9 && this.xx3 - this.xx2 > 0.1) {
            this.G.drawLine(60 + (int)(dx * this.xx3), this.alto - 50, 60 + (int)(dx * this.xx3), this.alto - 55);
            this.G.drawLine(61 + (int)(dx * this.xx3), this.alto - 50, 61 + (int)(dx * this.xx3), this.alto - 55);
            this.G.drawString(this.doubleCaster(this.h3), 52 + (int)(dx * this.xx3), this.alto - 35);
        }
        this.G.drawLine(60 + (int)(dx * 1.0), this.alto - 50, 60 + (int)(dx * 1.0), this.alto - 55);
        this.G.drawLine(61 + (int)(dx * 1.0), this.alto - 50, 61 + (int)(dx * 1.0), this.alto - 55);
        this.G.drawString(this.doubleCaster(this.h4), 52 + (int)(dx * 1.0) - 2 * this.doubleCaster(this.h4).length(), this.alto - 35);
    }

    private void dibujarMarco() {
        int[] cy;
        int[] cx;
        if (this.G == null) {
            return;
        }
        this.G.setColor(new Color(0));
        this.G.drawRect(50, 20, this.ancho - 70, this.alto - 70);
        this.G.drawRect(51, 21, this.ancho - 72, this.alto - 72);
        this.dibujarEscalas();
        String[] modo = Grafo.getIndexingOptions();
        String[] campo = this.GR.getCampos();
        this.G.setColor(new Color(0xEEEEEE));
        this.G.fillRect(5, 2, 100, 15);
        this.G.fillRect(this.ancho - 105, this.alto - 17, 100, 15);
        this.G.fillRect(this.ancho / 2, 2, 100, 15);
        this.G.fillRect(this.ancho / 2 - 100, 2, 90, 15);
        this.G.setColor(new Color(0xBBBBBB));
        this.G.drawRect(5, 2, 100, 15);
        this.G.drawRect(this.ancho - 105, this.alto - 17, 100, 15);
        this.G.drawRect(this.ancho / 2, 2, 100, 15);
        this.G.drawRect(this.ancho / 2 - 100, 2, 90, 15);
        this.G.drawRect(this.ancho / 2 - 70, 2, 30, 15);
        this.G.setColor(new Color(0));
        this.G.setFont(new Font("Arial", 1, 11));
        this.G.drawString(campo[this.scaleY], 8, 14);
        this.G.drawString(campo[this.scaleX], this.ancho - 101, this.alto - 5);
        this.G.setFont(new Font("Arial", 0, 11));
        this.G.drawString(modo[this.style], this.ancho / 2 + 2, 14);
        if (this.relacionV != 2) {
            this.G.drawLine(this.ancho / 2 - 85, 4, this.ancho / 2 - 85, 15);
        }
        if (this.relacionV == 0 || this.relacionV == 1) {
            cx = new int[]{this.ancho / 2 - 90, this.ancho / 2 - 85, this.ancho / 2 - 80};
            cy = new int[]{8, 3, 8};
            this.G.drawPolygon(cx, cy, 3);
        }
        if (this.relacionV == 0 || this.relacionV == 3) {
            cx = new int[]{this.ancho / 2 - 90, this.ancho / 2 - 85, this.ancho / 2 - 80};
            cy = new int[]{11, 16, 11};
            this.G.drawPolygon(cx, cy, 3);
        }
        if (this.relacionV == 2) {
            this.G.drawLine(this.ancho / 2 - 82, 8, this.ancho / 2 - 88, 8);
            this.G.drawLine(this.ancho / 2 - 82, 11, this.ancho / 2 - 88, 11);
        }
        if (this.relacionH != 2) {
            this.G.drawLine(this.ancho / 2 - 65, 10, this.ancho / 2 - 45, 10);
        }
        if (this.relacionH == 0 || this.relacionH == 1) {
            cx = new int[]{this.ancho / 2 - 59, this.ancho / 2 - 65, this.ancho / 2 - 59};
            cy = new int[]{5, 10, 15};
            this.G.drawPolygon(cx, cy, 3);
        }
        if (this.relacionH == 0 || this.relacionH == 3) {
            cx = new int[]{this.ancho / 2 - 51, this.ancho / 2 - 45, this.ancho / 2 - 51};
            cy = new int[]{5, 10, 15};
            this.G.drawPolygon(cx, cy, 3);
        }
        if (this.relacionH == 2) {
            this.G.drawLine(this.ancho / 2 - 52, 8, this.ancho / 2 - 58, 8);
            this.G.drawLine(this.ancho / 2 - 52, 11, this.ancho / 2 - 58, 11);
        }
        this.G.drawLine(this.ancho / 2 - 32, 12, this.ancho / 2 - 15, 9);
        if (this.arrowSize > 0) {
            cx = new int[]{this.ancho / 2 - 17 - this.arrowSize, this.ancho / 2 - 15, this.ancho / 2 - 15 - this.arrowSize};
            cy = new int[]{9 - this.arrowSize, 9, 10 + this.arrowSize};
            this.G.drawPolygon(cx, cy, 3);
        }
    }

    private void dibujarGrafo(boolean speed) {
        int i;
        for (int i2 = 0; i2 < this.NOD.length; ++i2) {
            this.G.setColor(new Color(0xFFDDAA));
            this.G.fillArc(this.NOD[i2][0] - this.arrowSize / 4 - 5, this.NOD[i2][1] - this.arrowSize / 4 - 5, this.arrowSize / 2 + 10, this.arrowSize / 2 + 10, 0, 360);
        }
        this.G.setColor(new Color(255));
        int count = 0;
        for (i = 0; i < this.ARC.length; ++i) {
            if (this.ARC[i][0] < 0 || this.ARC[i][1] < 0) continue;
            int ini = this.ARC[i][0];
            int fin = this.ARC[i][1];
            int x1 = this.NOD[ini][0];
            int y1 = this.NOD[ini][1];
            int x2 = this.NOD[fin][0];
            int y2 = this.NOD[fin][1];
            if (this.relacionH == 1 && this.n1[ini][1] <= this.n1[fin][1] || this.relacionH == 2 && this.n1[ini][1] != this.n1[fin][1] || this.relacionH == 3 && this.n1[ini][1] >= this.n1[fin][1] || this.relacionV == 1 && this.n2[ini][1] >= this.n2[fin][1] || this.relacionV == 2 && this.n2[ini][1] != this.n2[fin][1] || this.relacionV == 3 && this.n2[ini][1] <= this.n2[fin][1]) continue;
            this.G.drawLine(x1, y1, x2, y2);
            if (speed && this.arrowSize > 1) {
                int dx = x2 - x1;
                int dy = y2 - y1;
                int d = (int)Math.sqrt(dx * dx + dy * dy);
                if (d > 0) {
                    dx = dx * this.arrowSize / d;
                    dy = dy * this.arrowSize / d;
                    this.G.drawLine(x2, y2, x2 - dy - dx - dx, y2 + dx - dy - dy);
                    this.G.drawLine(x2, y2, x2 + dy - dx - dx, y2 - dx - dy - dy);
                    this.G.drawLine(x2 - dy - dx - dx, y2 + dx - dy - dy, x2 + dy - dx - dx, y2 - dx - dy - dy);
                } else {
                    this.G.drawArc(x1 - this.arrowSize, y1 - this.arrowSize, this.arrowSize + this.arrowSize, this.arrowSize + this.arrowSize, 0, 360);
                }
            }
            ++count;
        }
        this.G.setColor(new Color(0));
        this.G.drawString(count + " arcs", this.ancho - 80, 14);
        for (i = 0; i < this.NOD.length; ++i) {
            this.G.setColor(new Color(0xCC0000));
            this.G.drawArc(this.NOD[i][0] - this.arrowSize / 4 - 3, this.NOD[i][1] - this.arrowSize / 4 - 3, this.arrowSize / 2 + 6, this.arrowSize / 2 + 6, 0, 360);
        }
    }

    private void prepararVisualizacion() {
        int i;
        int deltax = this.ancho - 90;
        int deltay = this.alto - 90;
        this.n1 = this.GR.indexActors(this.scaleX, this.style);
        this.n2 = this.GR.indexActors(this.scaleY, this.style);
        double[][] ar = this.GR.getArcos();
        this.NOD = new int[this.n1.length][2];
        this.ARC = new int[ar.length][2];
        for (int i2 = 0; i2 < this.n1.length; ++i2) {
            int d1 = i2 % 4 == 1 || i2 % 4 == 2 ? 0 : 1;
            int d2 = i2 % 4 == 1 || i2 % 4 == 3 ? 0 : 1;
            this.NOD[i2][0] = (int)(this.n1[i2][2] * (double)deltax + 60.0) + d1;
            this.NOD[i2][1] = this.alto - 60 - (int)(this.n2[i2][2] * (double)deltay) + d2;
        }
        double ii1 = -2.0;
        double ii2 = -2.0;
        double ii3 = -2.0;
        for (i = 0; i < this.n1.length; ++i) {
            if (this.n1[i][2] == 0.0) {
                this.h0 = this.n1[i][1];
            }
            if (this.n1[i][2] == 1.0) {
                this.h4 = this.n1[i][1];
            }
            if (Math.abs(this.n1[i][2] - 0.25) < Math.abs(ii1 - 0.25)) {
                this.h1 = this.n1[i][1];
                ii1 = this.n1[i][2];
                this.xx1 = this.n1[i][2];
            }
            if (Math.abs(this.n1[i][2] - 0.5) < Math.abs(ii2 - 0.5)) {
                this.h2 = this.n1[i][1];
                ii2 = this.n1[i][2];
                this.xx2 = this.n1[i][2];
            }
            if (!(Math.abs(this.n1[i][2] - 0.75) < Math.abs(ii3 - 0.75))) continue;
            this.h3 = this.n1[i][1];
            ii3 = this.n1[i][2];
            this.xx3 = this.n1[i][2];
        }
        ii1 = -2.0;
        ii2 = -2.0;
        ii3 = -2.0;
        for (i = 0; i < this.n1.length; ++i) {
            if (this.n2[i][2] == 0.0) {
                this.v0 = this.n2[i][1];
            }
            if (this.n2[i][2] == 1.0) {
                this.v4 = this.n2[i][1];
            }
            if (Math.abs(this.n2[i][2] - 0.25) < Math.abs(ii1 - 0.25)) {
                this.v1 = this.n2[i][1];
                ii1 = this.n2[i][2];
                this.yy1 = this.n2[i][2];
            }
            if (Math.abs(this.n2[i][2] - 0.5) < Math.abs(ii2 - 0.5)) {
                this.v2 = this.n2[i][1];
                ii2 = this.n2[i][2];
                this.yy2 = this.n2[i][2];
            }
            if (!(Math.abs(this.n2[i][2] - 0.75) < Math.abs(ii3 - 0.75))) continue;
            this.v3 = this.n2[i][1];
            ii3 = this.n2[i][2];
            this.yy3 = this.n2[i][2];
        }
        for (i = 0; i < ar.length; ++i) {
            int j;
            this.ARC[i][0] = -1;
            this.ARC[i][1] = -1;
            for (j = 0; j < this.n1.length; ++j) {
                if (ar[i][0] != (double)((int)this.n1[j][0])) continue;
                this.ARC[i][0] = j;
            }
            for (j = 0; j < this.n1.length; ++j) {
                if (ar[i][1] != (double)((int)this.n1[j][0])) continue;
                this.ARC[i][1] = j;
            }
        }
    }

    private String doubleCaster(double x) {
        if (x == (double)((int)x) && x > -10000.0 && x < 10000.0) {
            return "" + (int)x;
        }
        if (Math.abs(x) < 0.01) {
            double y = Math.abs(x);
            y = (int)Math.log10(y);
            return "" + (double)((int)((x /= Math.pow(10.0, y)) * 100.0)) / 100.0 + " E" + (int)y;
        }
        if (x > -2.0 && x < 2.0) {
            return "" + (double)((int)(x * 1000.0)) / 1000.0;
        }
        if (x > -1000.0 && x < 1000.0) {
            return "" + (double)((int)(x * 100.0)) / 100.0;
        }
        if (x > 9999999.0 || x < 9999999.0) {
            double y = Math.abs(x);
            y = (int)Math.log10(y);
            return "" + (double)((int)((x /= Math.pow(10.0, y)) * 100.0)) / 100.0 + " e" + (int)y;
        }
        if (x == (double)((int)x)) {
            return "" + (int)x;
        }
        return "" + (double)((int)(x * 10.0)) / 10.0;
    }

    public void pausa(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

