/* (c) Mauricio Nivaldo Andres Monsalve Moreno, 2005

Proyecto para el curso CC52B, Computacion Grafica: SAMURAI

*/


#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

float r=0.5;
float cerca=4;
float ratioxy=1.5;
float fov=65.0;
float alangulo=1.1;
float piernas[4],izq[4],der[4];

float a1,a2,a3;

int n1=10;
int n2=15;
int wiref=-1;
int parte=0;
int luz=-1;

#define DOSPI 6.2832

#define COOR(A) A[0],A[1],A[2]
#define VEC(A,x,y,z) A[0]=x;A[1]=y;A[2]=z;
#define ANG(A,w,x,y,z) A[0]=w;A[1]=x;A[2]=y;A[3]=z;

float SX=0, SY=0, SZ=0, SANG=0, SVY=0;

/* A=BxC */
#define CRUZ(A,B,C) \
A[0]=B[1]*C[2]-B[2]*C[1]; \
A[1]=-B[0]*C[2]+B[2]*C[0]; \
A[2]=B[0]*C[1]-B[1]*C[0];

/* A=B-C */
#define RESTA(A,B,C) \
A[0]=B[0]-C[0]; \
A[1]=B[1]-C[1]; \
A[2]=B[2]-C[2];

/* A=a*B */
#define POND(A,a,B) \
A[0]=a*B[0]; \
A[1]=a*B[1]; \
A[2]=a*B[2];

/* A=B+C */
#define SUMA(A,B,C) \
A[0]=B[0]+C[0]; \
A[1]=B[1]+C[1]; \
A[2]=B[2]+C[2];

/* A=a*X+b*Y */
#define AXBY(A,a,B,b,C) \
A[0]=a*B[0]+b*C[0]; \
A[1]=a*B[1]+b*C[1]; \
A[2]=a*B[2]+b*C[2];

/* N=Norma(A) */
#define NORM(N,A) N=sqrt(A[0]*A[0]+A[1]*A[1]+A[2]*A[2]);

float espad_int=40;
float shomen=0;

typedef struct {
        GLubyte  *dibujo;
	GLuint	bpp;
	GLuint largo;
	GLuint ancho;
	GLuint ID;
}textura;

textura	texturas[4];

int cargarTGA( char *nombre, textura *imagen) {
	GLubyte		cabezeraTGA[12]={0,0,2,0,0,0,0,0,0,0,0,0};
        GLubyte         compararTGA[12];
	GLubyte		cabezera[6];
	GLuint		bytesporpunto;
	GLuint		tamanoimagen;
	GLuint		temp,i;
	GLuint		tipo=GL_RGBA;

	FILE *archivo=fopen(nombre, "rb");
	if( archivo == NULL ||
            fread(compararTGA,1,sizeof(compararTGA),archivo)!=sizeof(compararTGA)  ||
	    memcmp(cabezeraTGA,compararTGA,sizeof(compararTGA))!=0		||
	    fread(cabezera,1,sizeof(cabezera),archivo)!=sizeof(cabezera)) {
		if(archivo==NULL) {
			printf("No se encontro el archivo %s\n",nombre);
			return 0;
		}
		else {
			fclose(archivo);
			return 0;
		}
	}
	imagen->largo=256*cabezera[1]+ cabezera[0];
	imagen->ancho=256*cabezera[3]+ cabezera[2];
	if( imagen->largo <= 0 ||
	    imagen->ancho <= 0 ||
	    (cabezera[4]!=24 && cabezera[4]!=32)) {
                printf("Daton invalidos\n");
		fclose(archivo);
		return 0;
	}
	imagen->bpp=cabezera[4];
	bytesporpunto=cabezera[4]/8;
        tamanoimagen=imagen->largo * imagen->ancho * bytesporpunto;
	imagen->dibujo = (GLubyte *)malloc(tamanoimagen);
	if(imagen->dibujo== NULL ||
	   fread(imagen->dibujo, 1, tamanoimagen, archivo) != tamanoimagen ) {
		if(imagen->dibujo != NULL) {
			printf("Error leyendo imagen\n");
			free(imagen->dibujo);
		} else printf("Error asignando memoria\n");
		fclose(archivo);
		return -1;
	}
        for(i=0; i< (int)tamanoimagen; i+=bytesporpunto)
	{
		temp=imagen->dibujo[i];
		imagen->dibujo[i] = imagen->dibujo[i + 2];
		imagen->dibujo[i + 2] = temp;
	}
	fclose (archivo);
        glGenTextures( 1 , &imagen[0].ID);
        glBindTexture(GL_TEXTURE_2D, imagen[0].ID);
	if(imagen->bpp ==24) tipo= GL_RGB;
        glTexImage2D(GL_TEXTURE_2D, 0, tipo, imagen[0].ancho, imagen[0].largo, 0, tipo, GL_UNSIGNED_BYTE, imagen[0].dibujo);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	return 1;
}

void NorM(float a,float b,float c) {
     float r=a*a+b*b+c*c;
     r=sqrt(r);
     glNormal3f(a/r,b/r,c/r);
}

void MatC(float a,float b,float c) {
     float vec_aux[3];
     VEC(vec_aux,a/2,b/2,c/2);
     glMaterialfv(GL_FRONT,GL_DIFFUSE,vec_aux);
     VEC(vec_aux,a/1.5,b/1.5,c/1.5);
     glMaterialfv(GL_FRONT,GL_SPECULAR,vec_aux);
     VEC(vec_aux,a/2,b/2,c/2);
     glMaterialfv(GL_FRONT,GL_AMBIENT,vec_aux);
}

void grosbig(float *ini,float *fin,float rmax,float pot,float descentro,float ex) {
	float nor[3],ba1[3],ba2[3],pos[3],poss[3],r1,r2,alfa,omega;
	RESTA(nor,fin,ini);
	if ((nor[0]!=nor[1])|(nor[1]!=nor[2])|(nor[0]!=nor[2])) {VEC(ba2,1,1,1);}
		else {VEC(ba2,1,0,0);}
	CRUZ(ba1,nor,ba2);
	CRUZ(ba2,nor,ba1);
	NORM(alfa,ba1);
	POND(ba1,1/alfa,ba1);
	NORM(alfa,ba2);
	POND(ba2,1/alfa,ba2);
	for(alfa=0;alfa<1;alfa+=.25) {
		r1=rmax*pow(sin(alfa*3.1415),pot)+0.001;
		r2=rmax*pow(sin((alfa+.25)*3.1415),pot);
		omega=pow(alfa,descentro)*(1+ex)-ex/2;
		AXBY(pos,omega,ini,(1-omega),fin);
		omega=pow(alfa+.25,descentro)*(1+ex)-ex/2;
		AXBY(poss,omega,ini,(1-omega),fin);
		if (wiref<0) glBegin(GL_QUADS);
			else glBegin(GL_LINE_STRIP);
		for(omega=0;omega<DOSPI;omega+=DOSPI/6) {
			NorM(r1*cos(omega)*ba1[0]+r1*sin(omega)*ba2[0], \
				r1*cos(omega)*ba1[1]+r1*sin(omega)*ba2[1], \
				r1*cos(omega)*ba1[2]+r1*sin(omega)*ba2[2]);
			glVertex3f(pos[0]+r1*cos(omega)*ba1[0]+r1*sin(omega)*ba2[0], \
				pos[1]+r1*cos(omega)*ba1[1]+r1*sin(omega)*ba2[1], \
				pos[2]+r1*cos(omega)*ba1[2]+r1*sin(omega)*ba2[2]);
			NorM(r2*cos(omega)*ba1[0]+r2*sin(omega)*ba2[0], \
				r2*cos(omega)*ba1[1]+r2*sin(omega)*ba2[1], \
				r2*cos(omega)*ba1[2]+r2*sin(omega)*ba2[2]);
			glVertex3f(poss[0]+r2*cos(omega)*ba1[0]+r2*sin(omega)*ba2[0], \
				poss[1]+r2*cos(omega)*ba1[1]+r2*sin(omega)*ba2[1], \
				poss[2]+r2*cos(omega)*ba1[2]+r2*sin(omega)*ba2[2]);
			NorM(r2*cos(omega+DOSPI/6)*ba1[0]+r2*sin(omega+DOSPI/6)*ba2[0], \
				r2*cos(omega+DOSPI/6)*ba1[1]+r2*sin(omega+DOSPI/6)*ba2[1], \
				r2*cos(omega+DOSPI/6)*ba1[2]+r2*sin(omega+DOSPI/6)*ba2[2]);
			glVertex3f(poss[0]+r2*cos(omega+DOSPI/6)*ba1[0]+r2*sin(omega+DOSPI/6)*ba2[0], \
				poss[1]+r2*cos(omega+DOSPI/6)*ba1[1]+r2*sin(omega+DOSPI/6)*ba2[1], \
				poss[2]+r2*cos(omega+DOSPI/6)*ba1[2]+r2*sin(omega+DOSPI/6)*ba2[2]);
			NorM(r1*cos(omega+DOSPI/6)*ba1[0]+r1*sin(omega+DOSPI/6)*ba2[0], \
				r1*cos(omega+DOSPI/6)*ba1[1]+r1*sin(omega+DOSPI/6)*ba2[1], \
				r1*cos(omega+DOSPI/6)*ba1[2]+r1*sin(omega+DOSPI/6)*ba2[2]);
			glVertex3f(pos[0]+r1*cos(omega+DOSPI/6)*ba1[0]+r1*sin(omega+DOSPI/6)*ba2[0], \
				pos[1]+r1*cos(omega+DOSPI/6)*ba1[1]+r1*sin(omega+DOSPI/6)*ba2[1], \
				pos[2]+r1*cos(omega+DOSPI/6)*ba1[2]+r1*sin(omega+DOSPI/6)*ba2[2]);
		}
		glEnd();
	}
}

void conang(float *ini,float *fin,float *fren,float r1,float r2,float ang) {
	float nor[3],ba1[3],ba2[3],*pos,*poss,alfa,omega;
	RESTA(nor,fin,ini);
	CRUZ(ba2,nor,fren);
	CRUZ(ba1,ba2,nor);
	NORM(alfa,ba1);
	POND(ba1,1/alfa,ba1);
	NORM(alfa,ba2);
	POND(ba2,1/alfa,ba2);
	pos=ini;
	poss=fin;
	if (wiref<0) glBegin(GL_QUADS);
		else glBegin(GL_LINE_STRIP);
	for(omega=ang/2;omega<(DOSPI-ang/2);omega+=(DOSPI-ang)/6) {
		NorM(r1*cos(omega)*ba1[0]+r1*sin(omega)*ba2[0], \
			r1*cos(omega)*ba1[1]+r1*sin(omega)*ba2[1], \
			r1*cos(omega)*ba1[2]+r1*sin(omega)*ba2[2]);
		glVertex3f(pos[0]+r1*cos(omega)*ba1[0]+r1*sin(omega)*ba2[0], \
			pos[1]+r1*cos(omega)*ba1[1]+r1*sin(omega)*ba2[1], \
			pos[2]+r1*cos(omega)*ba1[2]+r1*sin(omega)*ba2[2]);
		NorM(r2*cos(omega)*ba1[0]+r2*sin(omega)*ba2[0], \
			r2*cos(omega)*ba1[1]+r2*sin(omega)*ba2[1], \
			r2*cos(omega)*ba1[2]+r2*sin(omega)*ba2[2]);
		glVertex3f(poss[0]+r2*cos(omega)*ba1[0]+r2*sin(omega)*ba2[0], \
			poss[1]+r2*cos(omega)*ba1[1]+r2*sin(omega)*ba2[1], \
			poss[2]+r2*cos(omega)*ba1[2]+r2*sin(omega)*ba2[2]);
		NorM(r2*cos(omega+(DOSPI-ang)/6)*ba1[0]+r2*sin(omega+(DOSPI-ang)/6)*ba2[0], \
			r2*cos(omega+(DOSPI-ang)/6)*ba1[1]+r2*sin(omega+(DOSPI-ang)/6)*ba2[1], \
			r2*cos(omega+(DOSPI-ang)/6)*ba1[2]+r2*sin(omega+(DOSPI-ang)/6)*ba2[2]);
		glVertex3f(poss[0]+r2*cos(omega+(DOSPI-ang)/6)*ba1[0]+r2*sin(omega+(DOSPI-ang)/6)*ba2[0], \
			poss[1]+r2*cos(omega+(DOSPI-ang)/6)*ba1[1]+r2*sin(omega+(DOSPI-ang)/6)*ba2[1], \
			poss[2]+r2*cos(omega+(DOSPI-ang)/6)*ba1[2]+r2*sin(omega+(DOSPI-ang)/6)*ba2[2]);
		NorM(r1*cos(omega+(DOSPI-ang)/6)*ba1[0]+r1*sin(omega+(DOSPI-ang)/6)*ba2[0], \
			r1*cos(omega+(DOSPI-ang)/6)*ba1[1]+r1*sin(omega+(DOSPI-ang)/6)*ba2[1], \
			r1*cos(omega+(DOSPI-ang)/6)*ba1[2]+r1*sin(omega+(DOSPI-ang)/6)*ba2[2]);
		glVertex3f(pos[0]+r1*cos(omega+(DOSPI-ang)/6)*ba1[0]+r1*sin(omega+(DOSPI-ang)/6)*ba2[0], \
			pos[1]+r1*cos(omega+(DOSPI-ang)/6)*ba1[1]+r1*sin(omega+(DOSPI-ang)/6)*ba2[1], \
			pos[2]+r1*cos(omega+(DOSPI-ang)/6)*ba1[2]+r1*sin(omega+(DOSPI-ang)/6)*ba2[2]);
	}
	glEnd();
}

void congral(float *ini,float *fin,float *fren,float a1,float b1,float a2,float b2) {
	float nor[3],ba1[3],ba2[3],*pos,*poss,alfa,omega;
	RESTA(nor,fin,ini);
	CRUZ(ba2,nor,fren);
	CRUZ(ba1,ba2,nor);
	NORM(alfa,ba1);
	POND(ba1,1/alfa,ba1);
	NORM(alfa,ba2);
	POND(ba2,1/alfa,ba2);
	pos=ini;
	poss=fin;
	if (wiref<0) glBegin(GL_QUADS);
		else glBegin(GL_LINE_STRIP);
	for(omega=0;omega<DOSPI;omega+=DOSPI/6) {
		NorM(a1*cos(omega)*ba1[0]+b1*sin(omega)*ba2[0], \
			a1*cos(omega)*ba1[1]+b1*sin(omega)*ba2[1], \
			a1*cos(omega)*ba1[2]+b1*sin(omega)*ba2[2]);
		glVertex3f(pos[0]+a1*cos(omega)*ba1[0]+b1*sin(omega)*ba2[0], \
			pos[1]+a1*cos(omega)*ba1[1]+b1*sin(omega)*ba2[1], \
			pos[2]+a1*cos(omega)*ba1[2]+b1*sin(omega)*ba2[2]);
		NorM(a2*cos(omega)*ba1[0]+b2*sin(omega)*ba2[0], \
			a2*cos(omega)*ba1[1]+b2*sin(omega)*ba2[1], \
			a2*cos(omega)*ba1[2]+b2*sin(omega)*ba2[2]);
		glVertex3f(poss[0]+a2*cos(omega)*ba1[0]+b2*sin(omega)*ba2[0], \
			poss[1]+a2*cos(omega)*ba1[1]+b2*sin(omega)*ba2[1], \
			poss[2]+a2*cos(omega)*ba1[2]+b2*sin(omega)*ba2[2]);
		NorM(a2*cos(omega+DOSPI/6)*ba1[0]+b2*sin(omega+DOSPI/6)*ba2[0], \
			a2*cos(omega+DOSPI/6)*ba1[1]+b2*sin(omega+DOSPI/6)*ba2[1], \
			a2*cos(omega+DOSPI/6)*ba1[2]+b2*sin(omega+DOSPI/6)*ba2[2]);
		glVertex3f(poss[0]+a2*cos(omega+DOSPI/6)*ba1[0]+b2*sin(omega+DOSPI/6)*ba2[0], \
			poss[1]+a2*cos(omega+DOSPI/6)*ba1[1]+b2*sin(omega+DOSPI/6)*ba2[1], \
			poss[2]+a2*cos(omega+DOSPI/6)*ba1[2]+b2*sin(omega+DOSPI/6)*ba2[2]);
		NorM(a1*cos(omega+DOSPI/6)*ba1[0]+b1*sin(omega+DOSPI/6)*ba2[0], \
			a1*cos(omega+DOSPI/6)*ba1[1]+b1*sin(omega+DOSPI/6)*ba2[1], \
			a1*cos(omega+DOSPI/6)*ba1[2]+b1*sin(omega+DOSPI/6)*ba2[2]);
		glVertex3f(pos[0]+a1*cos(omega+DOSPI/6)*ba1[0]+b1*sin(omega+DOSPI/6)*ba2[0], \
			pos[1]+a1*cos(omega+DOSPI/6)*ba1[1]+b1*sin(omega+DOSPI/6)*ba2[1], \
			pos[2]+a1*cos(omega+DOSPI/6)*ba1[2]+b1*sin(omega+DOSPI/6)*ba2[2]);
	}
	glEnd();
}

void cuadri(float *v1,float *v2,float *v3,float *v4) {
  if (wiref==-1) glBegin(GL_QUADS);
	else glBegin(GL_LINE_STRIP);
  glTexCoord2f(0,0);
  glVertex3f(COOR(v1));
  glTexCoord2f(0,1);
  glVertex3f(COOR(v2));
  glTexCoord2f(1,1);
  glVertex3f(COOR(v3));
  glTexCoord2f(1,0);
  glVertex3f(COOR(v4));
  glEnd();
}

void tri(float *v1,float *v2,float *v3) {
  if (wiref==-1) glBegin(GL_TRIANGLES);
	else glBegin(GL_LINE_STRIP);
  glTexCoord2f(0,0);
  glVertex3f(COOR(v1));
  glTexCoord2f(0,1);
  glVertex3f(COOR(v2));
  glTexCoord2f(.5,.5);
  glVertex3f(COOR(v3));
  glEnd();
}

void espad() {
  float psi1=0,theta1,theta1_t=0,cosp1;
  float psi2=0,theta2,theta2_t=0,cosp2;
  float espadazo=0,espadazo2=0;
  float AMP=22,TH1=-60.,TH2=-22.,sseno;
  espad_int+=1.3;
  sseno=sin(espad_int*3.14/20-3.1416);
  espadazo=espad_int+0.6*sseno*20/3.14;
  SVY=0.005+0.005*sin(espadazo*3.14/20);
  if (espad_int>80) espad_int=0;
  if (espadazo<21) {
	theta1_t=TH2+espadazo*(TH1-TH2)/20.;
	psi1=-AMP+espadazo*AMP/20;
  }
  if ( (espadazo>20) & (espadazo<41) ) {
	theta1_t=TH1-(espadazo-20)*TH1/20;
	psi1=AMP*(espadazo-20)/20;
  }
  if (espadazo>40) {
	theta1_t=(espadazo-40)*TH2/40;
	psi1=AMP-(espadazo-40)*AMP/20;
  }
  cosp1=cos(psi1*3.1416/180);
  theta1=psi1-theta1_t*cosp1*cosp1/(5-2*cosp1*sin(psi1*3.1416/180));
  espadazo2=espadazo-40;
  if (espadazo2<0) espadazo2+=80;
  if (espadazo2<21) {
	theta2_t=TH2+espadazo2*(TH1-TH2)/20.;
	psi2=-AMP+espadazo2*AMP/20;
  }
  if ( (espadazo2>20) & (espadazo2<41) ) {
	theta2_t=TH1-(espadazo2-20)*TH1/20;
	psi2=AMP*(espadazo2-20)/20;
  }
  if ( (espadazo2>40) & (espadazo2<81) ) {
	theta2_t=(espadazo2-40)*TH2/40;
	psi2=AMP-(espadazo2-40)*AMP/20;
  }
  cosp2=cos(psi2*3.1416/180);
  theta2=psi2-theta2_t*cosp2*cosp2/(5-2*cosp2*sin(psi2*3.1416/180));
  ANG(piernas,theta1*3.14/180,(theta1+theta1_t)*3.14/180,theta2*3.14/180,(theta2+theta2_t)*3.14/180);
  ANG(der,0.6+psi2/2000,1.05,0,-.67);
  ANG(izq,0.75+psi1/1000,1.25,0,.6);
}

void espad2() {
  float psi1=0,theta1,theta1_t=0,cosp1;
  float psi2=0,theta2,theta2_t=0,cosp2;
  float espadazo=0,espadazo2=0;
  float AMP=40,TH1=-70.,TH2=-10.,sseno;
  espad_int+=2.2;
  sseno=sin(espad_int*3.14/20-3.1416);
  espadazo=espad_int+0.7*sseno*20/3.14;
  SVY=0.02+0.02*sin(espadazo*3.14/20);
  if (espad_int>80) espad_int=0;
  if (espadazo<21) {
	theta1_t=TH2+espadazo*(TH1-TH2)/20.;
	psi1=-AMP+espadazo*AMP/20;
  }
  if ( (espadazo>20) & (espadazo<41) ) {
	theta1_t=TH1-(espadazo-20)*TH1/20;
	psi1=AMP*(espadazo-20)/20;
  }
  if (espadazo>40) {
	theta1_t=(espadazo-40)*TH2/40;
	psi1=AMP-(espadazo-40)*AMP/20;
  }
  cosp1=cos(psi1*3.1416/180);
  theta1=psi1-theta1_t*cosp1*cosp1/(5-2*cosp1*sin(psi1*3.1416/180));
  espadazo2=espadazo-40;
  if (espadazo2<0) espadazo2+=80;
  if (espadazo2<21) {
	theta2_t=TH2+espadazo2*(TH1-TH2)/20.;
	psi2=-AMP+espadazo2*AMP/20;
  }
  if ( (espadazo2>20) & (espadazo2<41) ) {
	theta2_t=TH1-(espadazo2-20)*TH1/20;
	psi2=AMP*(espadazo2-20)/20;
  }
  if ( (espadazo2>40) & (espadazo2<81) ) {
	theta2_t=(espadazo2-40)*TH2/40;
	psi2=AMP-(espadazo2-40)*AMP/20;
  }
  
  cosp2=cos(psi2*3.1416/180);
  theta2=psi2-theta2_t*cosp2*cosp2/(5-2*cosp2*sin(psi2*3.1416/180));
  ANG(piernas,theta1*3.14/180,(theta1+theta1_t)*3.14/180,theta2*3.14/180,(theta2+theta2_t)*3.14/180);
  ANG(der,0.1+psi2/60,1.45+psi2/40,0,0);
  ANG(izq,0.35+psi1/100,1.35+psi1/110,0,0);
}

void shomen_uchi() {
  /* La primera etapa consiste en iniciar el movimiento desde kamae */
  float psi1=0,theta1,theta1_t=0,cosp1;
  float psi2=0,theta2,theta2_t=0,cosp2;
  float espadazo=0,espadazo2=0,brazos=1.1;
  float AMP=20,TH1=-60.,TH2=-25.,sseno;
  espad_int+=3;
  sseno=sin(espad_int*3.14/20-3.1416);
  espadazo=espad_int+sseno*20/3.14;
  SVY=0.008+0.008*sin(espadazo*3.14/20);
  if (espad_int>80) espad_int=0;
  if (espadazo<21) {
	theta1_t=TH2+espadazo*(TH1-TH2)/20.;
	psi1=-AMP+espadazo*AMP/20;
  }
  if ( (espadazo>20) & (espadazo<41) ) {
	theta1_t=TH1-(espadazo-20)*TH1/20;
	psi1=AMP*(espadazo-20)/20;
  }
  if (espadazo>40) {
	theta1_t=(espadazo-40)*TH2/40;
	psi1=AMP-(espadazo-40)*AMP/20;
  }
  cosp1=cos(psi1*3.1416/180);
  theta1=psi1-theta1_t*cosp1*cosp1/(5-2*cosp1*sin(psi1*3.1416/180));
  espadazo2=espadazo-40;
  if (espadazo2<0) espadazo2+=80;
  if (espadazo2<21) {
	theta2_t=TH2+espadazo2*(TH1-TH2)/20.;
	psi2=-AMP+espadazo2*AMP/20;
  }
  if ( (espadazo2>20) & (espadazo2<41) ) {
	theta2_t=TH1-(espadazo2-20)*TH1/20;
	psi2=AMP*(espadazo2-20)/20;
  }
  if ( (espadazo2>40) & (espadazo2<81) ) {
	theta2_t=(espadazo2-40)*TH2/40;
	psi2=AMP-(espadazo2-40)*AMP/20;
  }
  cosp2=cos(psi2*3.1416/180);
  theta2=psi2-theta2_t*cosp2*cosp2/(5-2*cosp2*sin(psi2*3.1416/180));
  theta1-=AMP;
  theta2+=AMP;
  ANG(piernas,theta1*3.14/180,(theta1+theta1_t)*3.14/180,theta2*3.14/180,(theta2+theta2_t)*3.14/180);
  if (espadazo<45) brazos=3.14*(espadazo)/60*0.8;
  if (espadazo>44) brazos=( 3.14*45/60-3.14*(espadazo-45)/45 )*0.8;
  ANG(der,0.4+brazos,1.05+brazos*1.5,0,-.67);
  ANG(izq,0.55+brazos,1.25+brazos*1.5,0,.6);
}

float posit(float alf) {
	if (alf<=0) return 0;
	return alf;
}

void conal(float x,float y,float z,float r1,float y2,float r2) {
  int i=0,j=-1;
  if (wiref==-1) glBegin(GL_QUADS);
	else glBegin(GL_LINES);
  for(;i<6;i++) {
	glVertex3f(x+r1*cos(6.2832*i/6),y,z+r1*sin(6.2832*i/6));
	glVertex3f(x+r2*cos(6.2832*i/6),y2,z+r2*sin(6.2832*i/6));
	glVertex3f(x+r2*cos(6.2832*(i+1)/6),y2,z+r2*sin(6.2832*(i+1)/6));
	glVertex3f(x+r1*cos(6.2832*(i+1)/6),y,z+r1*sin(6.2832*(i+1)/6));
	j*=-1;
  }
  glEnd();
}

void samurai() {
  float v1[3],v2[3],v3[3],v4[3],*brazo,alto,desp1,desp2,calto;

  glTranslatef(SX,SY+SVY+0.1,SZ);
  glRotatef(SANG*180/3.1416,0,1,0);

  MatC(.35,.3,.3);
  /* Brazo derecho */
  brazo=der;
  MatC(.3,.3,.35);
  VEC(v1,.5,1,0);VEC(v2,.45+.8*sin(brazo[2]),1-.8*cos(brazo[0])*cos(brazo[2]),.6*sin(brazo[0])*cos(brazo[2]));
  grosbig(v1,v2,.16,.6,1,.15);
  MatC(.35,.3,.3);
  VEC(v1,.6*sin(brazo[3]),-.6*cos(brazo[1])*cos(brazo[3]),.6*sin(brazo[1])*cos(brazo[3]));
  SUMA(v1,v1,v2);grosbig(v2,v1,.14,.7,.6,.15);
  /* Mano derecha */
  MatC(.8,.6,.4);
  VEC(v2,.25*sin(brazo[3]),-.25*cos(brazo[1])*cos(brazo[3]),.25*sin(brazo[1])*cos(brazo[3]));
  SUMA(v2,v1,v2);grosbig(v2,v1,.12,.7,.7,.3);

  /* Brazo izquierdo */
  brazo=izq;
  MatC(.3,.3,.35);
  VEC(v1,-.5,1,0);VEC(v2,-.45+.8*sin(brazo[2]),1-.8*cos(brazo[0])*cos(brazo[2]),.6*sin(brazo[0])*cos(brazo[2]));
  grosbig(v1,v2,.16,.6,1,.15);
  MatC(.35,.3,.3);
  VEC(v1,.6*sin(brazo[3]),-.6*cos(brazo[1])*cos(brazo[3]),.6*sin(brazo[1])*cos(brazo[3]));
  SUMA(v1,v1,v2);grosbig(v2,v1,.14,.7,.6,.15);
  /* Mano izquierda */
  MatC(.8,.6,.4);
  VEC(v2,.25*sin(brazo[3]),-.25*cos(brazo[1])*cos(brazo[3]),.25*sin(brazo[1])*cos(brazo[3]));
  SUMA(v2,v1,v2);grosbig(v2,v1,.12,.7,.6,.25);
  /* Katana */
  MatC(.6,.7,.9);
  VEC(v1,1.7*sin(brazo[3]),1.7*sin(brazo[1])*cos(brazo[3]),1.7*cos(brazo[1])*cos(brazo[3]));
  SUMA(v1,v1,v2);grosbig(v2,v1,.05,.7,1,.25);

  /* Pierna derecha */
  MatC(.3,.3,.4);
  VEC(v1,.18,-.1,0);VEC(v2,.2,-cos(piernas[0]),sin(piernas[0]));grosbig(v1,v2,.19,.35,1,.2);
  MatC(.25,.25,.3);
  VEC(v1,0,-cos(piernas[1]),sin(piernas[1]));SUMA(v1,v1,v2);grosbig(v2,v1,.17,.8,.5,.08);
  /* Pie derecho */
  VEC(v2,0,0.5*sin(piernas[1]),0.5*cos(piernas[1]));
  VEC(v3,.06,-0.6*sin(piernas[1]),-0.6*cos(piernas[1]));
  SUMA(v2,v1,v2);SUMA(v3,v3,v2);
  grosbig(v2,v3,.1,1.5,1.5,0);
  
  /* Pierna izquierda */
  MatC(.3,.3,.4);
  VEC(v1,-.18,-.1,0);VEC(v2,-.2,-cos(piernas[2]),sin(piernas[2]));grosbig(v1,v2,.19,.35,1,.2);
  MatC(.25,.25,.3);
  VEC(v1,0,-cos(piernas[3]),sin(piernas[3]));SUMA(v1,v1,v2);grosbig(v2,v1,.17,.8,.5,.08);
  /* Pie izquierdo */
  VEC(v2,0,0.5*sin(piernas[3]),0.5*cos(piernas[3]));
  VEC(v3,-.06,-0.6*sin(piernas[3]),-0.6*cos(piernas[3]));
  SUMA(v2,v1,v2);SUMA(v3,v3,v2);
  grosbig(v2,v3,.1,1.8,1.5,0);
  
  /* Entrepiernas? */
  MatC(.35,.25,.15);
  VEC(v1,.2,-.1,0);VEC(v2,-.2,-.1,0);grosbig(v1,v2,.2,.1,1,0);
  
  /* Hombros */
  alto=posit(der[0]-3.14*2/9);
  calto=0.3*sin(alto);
  alto=0.4*sin(alto);
  MatC(.6,.4,0);
  NorM(0,1,-.5);
  VEC(v1,.3,1.1,0);VEC(v2,1,1,0);VEC(v3,1,.9,-.3);VEC(v4,.3,.9,-.3);cuadri(v1,v2,v3,v4);
  NorM(0,1,.5);
  VEC(v1,.3,1.1,0);VEC(v2,1,1,0);VEC(v3,1,.9+alto*.85,.3-calto);VEC(v4,.3,.9+alto,.3-calto);cuadri(v1,v2,v3,v4);
  alto=posit(izq[0]-3.14*1/6);
  calto=0.3*sin(alto);
  alto=0.4*sin(alto);
  NorM(0,1,-.5);
  VEC(v1,-.3,1.1,0);VEC(v2,-1,1,0);VEC(v3,-1,.9,-.3);VEC(v4,-.3,.9,-.3);cuadri(v1,v2,v3,v4);
  NorM(0,1,.5);
  VEC(v1,-.3,1.1,0);VEC(v2,-1,1,0);VEC(v3,-1,.9+alto*.85,.3-calto);VEC(v4,-.3,.9+alto,.3-calto);cuadri(v1,v2,v3,v4);
  
  /* Torax y abdomen */
  MatC(.45,.35,.25);
  VEC(v1,0,1.05,0);VEC(v2,0,0.95,0);VEC(v3,0,0,1);congral(v1,v2,v3,0.1,0.2,0.32,0.55);
  VEC(v1,0,0.95,0);VEC(v2,0,0.5,0);VEC(v3,0,0,1);congral(v1,v2,v3,0.32,0.55,0.22,0.27);
  VEC(v1,0,0.5,0);VEC(v2,0,0,0);VEC(v3,0,0,1);congral(v1,v2,v3,0.22,0.27,0.2,0.26);
  
  /* Falda */
  MatC(.55,.4,.3);
  desp1=(piernas[2]-piernas[0])*.15;
  desp2=(pow(piernas[0],2)+pow(piernas[2],2))*.4;
  NorM(desp1,desp2,1);
  VEC(v1,-0.11,0,0.22);VEC(v2,0.11,0,0.22);
  VEC(v3,0.12+desp1,-0.6+desp2*.5,0.3+desp2-desp1*.3);VEC(v4,-0.12+desp1,-0.6+desp2*.5,0.3+desp2+desp1*.3);cuadri(v1,v2,v3,v4);
  NorM(-desp1,desp2,-1);
  VEC(v1,0.12,0,-0.22);VEC(v2,-0.12,0,-0.22);
  VEC(v3,-0.13-desp1,-0.6+desp2*.5,-0.3-desp2+desp1*.3);VEC(v4,0.13-desp1,-0.6+desp2*.5,-0.3-desp2-desp1*.3);cuadri(v1,v2,v3,v4);
  MatC(.5,.35,.3);NorM(0,-.3,1);
  VEC(v1,-0.11,0,0.22);VEC(v2,0.11,0,0.22);
  VEC(v3,0.125,0.2,0.27);VEC(v4,-0.125,0.2,0.27);cuadri(v1,v2,v3,v4);
  NorM(0,-.3,-1);
  VEC(v1,-0.12,0,-0.22);VEC(v2,0.12,0,-0.22);
  VEC(v3,0.13,0.2,-0.27);VEC(v4,-0.13,0.2,-0.27);cuadri(v1,v2,v3,v4);
  NorM(1,-0.2,0);
  VEC(v1,0.27,0,0.12);VEC(v2,0.25,0,-0.12);
  VEC(v3,0.3,0.2,-0.12);VEC(v4,0.3,0.2,0.12);cuadri(v1,v2,v3,v4);
  NorM(1,0.2,0);
  VEC(v1,0.27,0,0.12);VEC(v2,0.25,0,-0.12);
  VEC(v3,0.3,-0.2,-0.15);VEC(v4,0.3,-0.2,0.15);cuadri(v1,v2,v3,v4);
  NorM(-1,-0.2,0);
  VEC(v1,-0.27,0,0.12);VEC(v2,-0.25,0,-0.12);
  VEC(v3,-0.3,0.2,-0.12);VEC(v4,-0.3,0.2,0.12);cuadri(v1,v2,v3,v4);
  NorM(-1,0.2,0);
  VEC(v1,-0.27,0,0.12);VEC(v2,-0.25,0,-0.12);
  VEC(v3,-0.3,-0.2,-0.15);VEC(v4,-0.3,-0.2,0.15);cuadri(v1,v2,v3,v4);
  MatC(.2,.2,.5);
  VEC(v1,0.3,0.2,0.35);VEC(v2,0.24,-0.5,-1.6);grosbig(v1,v2,.05,.02,2,0);
  
  /* Cabeza */
  MatC(.3,.3,.35);
  VEC(v1,0,1.51,0);VEC(v2,0,1.25,0);VEC(v3,0,0,1);conang(v1,v2,v3,0.25,0.3,2);
  VEC(v1,0,1.25,0);VEC(v2,0,1.1,0);VEC(v3,0,0,1);conang(v1,v2,v3,0.3,0.4,2);
  VEC(v1,0,1.49,0);VEC(v2,0,1.6,0);VEC(v3,0,0,1);conang(v1,v2,v3,0.25,0.15,0);
  VEC(v1,0,1.6,0);VEC(v2,0,1.7,0);VEC(v3,0,0,1);conang(v1,v2,v3,0.15,0,0);
  MatC(.8,.6,.4);
  VEC(v1,0,0.9,0);VEC(v2,0,1.1,0);VEC(v3,0,0,1);conang(v1,v2,v3,0.12,0.12,0);
  VEC(v1,0,1.1,0);VEC(v2,0,1.2,0);VEC(v3,0,0,1);conang(v1,v2,v3,0.12,0.22,0);
  VEC(v1,0,1.2,0);VEC(v2,0,1.5,0);VEC(v3,0,0,1);conang(v1,v2,v3,0.22,0.15,0);
  MatC(.8,.5,.2);
  VEC(v1,.3,1.8,.2);VEC(v2,.15,1.5,.25);VEC(v3,0,0,1);conang(v1,v2,v3,0,0.02,0);
  VEC(v1,-.3,1.8,.2);VEC(v2,-.15,1.5,.25);VEC(v3,0,0,1);conang(v1,v2,v3,0,0.02,0);
  VEC(v1,-.15,1.5,.25);VEC(v2,.15,1.5,.25);VEC(v3,0,0,1);conang(v1,v2,v3,0.02,0.02,0);
}

void kamina() {
  if (parte<20) a1=(parte-10)/10.;
     else a1=(30-parte)/10.;
  ANG(piernas,.5*a1,.5*a1,-.5*a1,-.5*a1);
}

void display()
{
  float v1[3],v2[3],v3[3],v4[3];
  float pos[4],amb[4],esp[4],dif[4];

  /* glClearColor (0.0, 0.0, 0.0, 0.0); */
  glClear (GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
  if (parte>100*DOSPI) parte=0;

  glMatrixMode(GL_PROJECTION);
  glPushMatrix();
  glLoadIdentity();
  gluPerspective(fov,ratioxy,2.2,50.0);

  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glLoadIdentity();
  gluLookAt(-cerca*sin(SANG-r)+SX,1+SY+SVY*3,-cerca*cos(SANG-r)+SZ, SX,SY+0.5+SVY*.2,SZ ,0,1,0 );

  ANG(pos,6,3,-9,1);
  ANG(amb,0.1,0.1,0.2,1);
  if (luz==1) {ANG(amb,0.6,0.6,0.7,1);}
  ANG(dif,0.5,0.6,0.8,1);
  ANG(esp,1,1,1,1);
  glLightfv(GL_LIGHT0,GL_AMBIENT,amb);
  glLightfv(GL_LIGHT0,GL_DIFFUSE,dif);
  glLightfv(GL_LIGHT0,GL_SPECULAR,esp);
  glLightfv(GL_LIGHT0,GL_POSITION,pos);
  glEnable(GL_LIGHT0);

  ANG(pos,-7.9,-1.9,7.5,0);
  ANG(amb,0.1,0.05,0,1);
  if (luz==1) {ANG(amb,0.6,0.6,0.7,1);}
  ANG(dif,.4,.2,0,1);
  ANG(esp,.5,.3,0,1);
  glLightfv(GL_LIGHT1,GL_AMBIENT,amb);
  glLightfv(GL_LIGHT1,GL_DIFFUSE,dif);
  glLightfv(GL_LIGHT1,GL_SPECULAR,esp);
  glLightfv(GL_LIGHT1,GL_POSITION,pos);
  glEnable(GL_LIGHT1);

  ANG(pos,-19,5,-24,1);
  ANG(amb,0.1,0.05,0,1);
  if (luz==1) {ANG(amb,0.6,0.6,0.7,1);}
  ANG(dif,.3,.5,.7,1);
  ANG(esp,.5,.8,1,1);
  glLightfv(GL_LIGHT1,GL_AMBIENT,amb);
  glLightfv(GL_LIGHT1,GL_DIFFUSE,dif);
  glLightfv(GL_LIGHT1,GL_SPECULAR,esp);
  glLightfv(GL_LIGHT1,GL_POSITION,pos);
  glEnable(GL_LIGHT2);

if (luz==1) {
  glDisable(GL_LIGHT3);
  ANG(pos,5,1,-20,1);
  ANG(amb,0.1,0.05,0,1);
  ANG(dif,.3,.5,.7,1);
  ANG(esp,.5,.8,1,1);
  glLightfv(GL_LIGHT1,GL_AMBIENT,amb);
  glLightfv(GL_LIGHT1,GL_DIFFUSE,dif);
  glLightfv(GL_LIGHT1,GL_SPECULAR,esp);
  glLightfv(GL_LIGHT1,GL_POSITION,pos);
  glEnable(GL_LIGHT3);
}

  /* Cuarto principal */
  glBindTexture(GL_TEXTURE_2D,texturas[2].ID);
  glBegin(GL_QUADS);
  MatC(.4,.75,.65);
  NorM(0,1,0);
  glTexCoord2f(0,0);
  glVertex3f(-8,-2,-8);
  glTexCoord2f(1,0);
  glVertex3f(8,-2,-8);
  glTexCoord2f(1,1);
  glVertex3f(8,-2,8);
  glTexCoord2f(0,1);
  glVertex3f(-8,-2,8);
  glEnd();

  glBindTexture(GL_TEXTURE_2D,texturas[1].ID);
  glBegin(GL_QUADS);
  MatC(.65,.6,.4);
  NorM(0,1,0);
  glTexCoord2f(0,0);
  glVertex3f(20,-2,-8);
  glTexCoord2f(3,0);
  glVertex3f(-20,-2,-8);
  glTexCoord2f(3,2);
  glVertex3f(-20,-2,-25);
  glTexCoord2f(0,2);
  glVertex3f(20,-2,-25);
  glEnd();

  /* Arriba */
  glBindTexture(GL_TEXTURE_2D,texturas[0].ID);
  glBegin(GL_QUADS);
  MatC(.6,.7,.4);
  NorM(0,-1,0);
  glTexCoord2f(0,0);
  glVertex3f(-8,3,-8);
  glTexCoord2f(2,0);
  glVertex3f(8,3,-8);
  glTexCoord2f(2,2);
  glVertex3f(8,3,8);
  glTexCoord2f(0,2);
  glVertex3f(-8,3,8);
  glEnd();
  
  MatC(.6,.6,.4);
  VEC(v1,-8,6,-8);VEC(v4,-8,-2,-8);
  NorM(1,0,0);
  VEC(v2,-8,6,8);VEC(v3,-8,-2,8);cuadri(v2,v3,v4,v1);
  NorM(0,0,-1);
  VEC(v1,8,-2,8);VEC(v4,8,6,8);cuadri(v2,v3,v1,v4);
  NorM(-1,0,0);
  VEC(v2,8,6,-8);VEC(v3,8,-2,-8);cuadri(v2,v3,v1,v4);
  NorM(0,0,-1);
  VEC(v1,8,6,-8);VEC(v2,8,3,-8);
  VEC(v3,-8,3,-8);VEC(v4,-8,6,-8);cuadri(v1,v2,v3,v4);

  glBindTexture(GL_TEXTURE_2D,texturas[2].ID);
  MatC(.3,.7,.55);NorM(0,1,-1);
  VEC(v1,20,-2,-8);VEC(v2,8,-2,-8);
  VEC(v3,8,6,0);VEC(v4,20,2,0);cuadri(v1,v2,v3,v4);
  
  MatC(.5,.7,.5);NorM(0,1,-2);
  VEC(v1,-25,-2,-8);VEC(v2,-8,-2,-8);
  VEC(v3,-8,7,0);VEC(v4,-25,9,0);cuadri(v1,v2,v3,v4);
  
  glBindTexture(GL_TEXTURE_2D,texturas[3].ID);
  MatC(.6,.6,.5);NorM(1,0,0);
  VEC(v1,-20,-2,-4);VEC(v2,-20,-2,-25);
  VEC(v3,-20,4,-25);VEC(v4,-20,4,-4);cuadri(v2,v3,v4,v1);

  MatC(.65,.65,.55);NorM(0,0,1);
  VEC(v1,-20,-2,-25);VEC(v2,-20,8,-25);
  VEC(v3,20,8,-25);VEC(v4,20,-2,-25);cuadri(v1,v2,v3,v4);

  glBindTexture(GL_TEXTURE_2D,0);
  MatC(0,.2,.25);NorM(0,1,0);
  VEC(v1,20,-4,12);VEC(v2,20,-4,-32);
  VEC(v3,26,-4,-32);VEC(v4,26,-4,12);cuadri(v2,v3,v4,v1);

  glBindTexture(GL_TEXTURE_2D,texturas[1].ID);
  MatC(.1,.4,.35);NorM(-1,1,0);
  VEC(v1,25,-5,8);VEC(v2,25,-5,-28);
  VEC(v3,35,10,-28);VEC(v4,35,8,8);cuadri(v2,v3,v4,v1);

  MatC(.08,.3,.25);NorM(-1,1,1);
  VEC(v1,15,-5,-32);VEC(v2,35,-5,-28);
  VEC(v3,35,10,-28);VEC(v4,15,6,-32);cuadri(v3,v4,v1,v2);

  glBindTexture(GL_TEXTURE_2D,0);
  MatC(.8,.5,.3);
  VEC(v1,-2.5,-2,-24.5);VEC(v2,-2.5,6.5,-24.5);
  grosbig(v1,v2,.5,.02,2,0);
  VEC(v1,2.5,-2,-24.5);VEC(v2,2.5,6.5,-24.5);
  grosbig(v1,v2,.4,.02,2,0);
  VEC(v1,4,3,-24.5);VEC(v2,-4,3,-24.5);
  grosbig(v1,v2,.4,.02,2,0);
  VEC(v1,5,5,-24.5);VEC(v2,-5,5,-24.5);
  grosbig(v1,v2,.4,.02,2,0);
  VEC(v1,0,5,-24.5);VEC(v2,0,3,-24.5);
  grosbig(v1,v2,.3,.02,2,0);

  glBindTexture(GL_TEXTURE_2D,0);
  samurai();

  glPopMatrix();
  glMatrixMode(GL_PROJECTION);
  glPopMatrix();

  glFlush ();
  glutSwapBuffers();
}

void retaman(int a,int b) {
  ratioxy=1.0*a/b;
  display();
}

int invalido(double a,double b) {
  if ( (a<6.3) & (a>-6.3) & (b<6.3) & (b>=-8) ) return 0;
  if ( (a<19.5) & (a>-18.3) & (b<=-8) & (b>-23.3) ) return 0;
  return 1;
}

void especial(unsigned char tec,int a,int b) {
  double px=SX,pz=SZ;
  if (tec=='x') r=r-0.2;
  if (tec=='z') r=r+0.2;
  if (tec=='s') cerca+=0.4;
  if (tec=='a') cerca-=0.4;
  if (tec=='q') exit(EXIT_SUCCESS);
  if (tec==' ') espad();
  if (tec=='b') SANG+=0.15;
  if (tec=='m') SANG-=0.15;
  if (tec=='n') {SX+=0.045*sin(SANG);SZ+=0.045*cos(SANG);espad();}
  if (tec=='h') {SX+=0.15*sin(SANG);SZ+=0.15*cos(SANG);espad2();}
  if (tec=='j') {SX+=0.12*sin(SANG);SZ+=0.12*cos(SANG);shomen_uchi();}
  if (tec=='l') luz=-luz;
  if (n2<1) n2=1;
  if (n1<1) n1=1;
  if (cerca<0.75) cerca=0.75;
  if (cerca>30) cerca=30;
  display();
  if (invalido(SX,SZ)) {SX=px;SZ=pz;}
  /* kamina(); */
}

int main(int argc, char** argv)
{
  printf("PROYECTO de CC52B, Computacion Grafica \n");
  printf("\t \t (c) Mauricio Monsalve Moreno\n");
  printf("\t \t SAMURAI - recreacion de kendo\n \n");
  printf("Botones:\n");
  printf("\t z   \t Girar la camara por la izquierda \n");
  printf("\t x   \t Girar la camara por la derecha \n");
  printf("\t a   \t Vuelo de acercamiento de la camara \n");
  printf("\t s   \t Vuelo de alejamiento de la camara \n");
  printf("\t b,m \t Cambiar el sentido del samurai\n");
  printf("\t n \t Caminar\n");
  printf("\t h \t Correr\n");
  printf("\t j \t Atacar (Shomen Uchi)\n");
  printf("\t q   \t Salir del programa (de forma manual)\n");
  ANG(piernas,1.5,-.4,.2,-.2);
  ANG(izq,0,0,-.2,.2);
  ANG(der,-.5,1.7,.2,-.2);
  glutInit(&argc, argv);
  glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB);
  glutInitWindowSize (540, 420);
  glutInitWindowPosition (100, 100);
  glutCreateWindow ("SAMURAI - Proyecto CC52B");
  glEnable(GL_LIGHTING);
  glEnable(GL_DEPTH_TEST);
  glEnable(GL_LIGHT0);
  glShadeModel(GL_SMOOTH);
  glEnable(GL_TEXTURE_2D);
  if(!cargarTGA("img1.tga", &texturas[0])) { 
	printf("Error cargando textura\n");
	exit(1);
  }
  if(!cargarTGA("img2.tga", &texturas[1])) { 
	printf("Error cargando textura\n");
	exit(1);
  }
  if(!cargarTGA("img3.tga", &texturas[2])) { 
	printf("Error cargando textura\n");
	exit(1);
  }
  if(!cargarTGA("img4.tga", &texturas[3])) { 
	printf("Error cargando textura\n");
	exit(1);
  }
  glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
  glutDisplayFunc(display);
  espad();
  /* glutReshapeFunc(retaman); */
  glutKeyboardFunc(especial);
  glutMainLoop();
  return 0;
}


