package Scenes;

import Scenes.*;
import java.awt.*;

public class TestAnim2
{
  static int width= 200;
  static int height= 150;
  static int step= 3;
  static int sleep= 30;

  public static void main(String args[])
  {
    if (args.length>=1) step= Integer.parseInt(args[0]);
    if (args.length>=2) sleep= Integer.parseInt(args[1]);
    if (args.length>=3) width= Integer.parseInt(args[2]);
    if (args.length>=4) height= Integer.parseInt(args[3]);

    Grob[] grobs= new Grob[8];
    double[] angles= new double[grobs.length];

    Animator anim= new Animator(width, height, "Animator");
    grobs[0]= new Text("Texto", Color.black, 10, 10);
    grobs[1]= new Ellipse(Color.black, Color.white, 20, 20, 20, 20);
    grobs[2]= new Ellipse(Color.red, Color.green, 20, 20, 30, 10);
    grobs[3]= new Box(Color.black, Color.white, 30, 30, 30, 15);
    grobs[4]= new Box(Color.black, Color.red, 20, 25, 20, 25);
    grobs[5]= new Text("Hola", Color.white, 10, 10);
    grobs[6]= new Box(Color.white, Color.black, 20, 20, 50, 30);
    grobs[7]= new Ellipse(Color.white, Color.black, 20, 20, 40, 25);

    System.out.println("objetos graficos= "+grobs.length);
    for (int i=0; i<grobs.length; i++)
    {
      angles[i]= 2*Math.PI*Math.random();
      if (grobs[i]!=null) anim.push(grobs[i]);
    }

    for(int i=1; ; i++)
    {
      for (int j=0; j<grobs.length; j++)
       if (grobs[j]!=null) angles[j]= Mover(grobs[j], angles[j]);
      if (i%20==0) anim.bot().raise();
      if (i%90==45) ((Ellipse)grobs[1]).setDim(25, 25);
      if (i%90==0) ((Ellipse)grobs[1]).setDim(20, 20);
      if (i%100==45) ((Box)grobs[6]).setDim(40, 20);
      if (i%100==0) ((Box)grobs[6]).setDim(50, 30);
      anim.sleep(sleep);
    }
  }

  public static double Mover(Grob grob, double angle)
  {
    int x= grob.getX();
    int y= grob.getY();
    for (;;)
    {
      int newx= x+ (int)(step*Math.cos(angle));
      int newy= y+ (int)(step*Math.sin(angle));

      if (newx<10 || newx>=width-10 || newy<10 || newy>=height-10)
      {
        angle= 2*Math.PI*Math.random();
        // System.out.println("Bounce "+newx+" "+newy);
      }
      else
      {
        grob.moveTo(newx, newy);
        // System.out.println(grob.getClass().getName()+" en "+newx+","+newy);
        return angle;
  } } }
}
