package Scenes;

import Scenes.*;
import java.awt.*;

public class TestAnim
{
  static int width= 200;
  static int height= 150;
  static int step= 3;
  static int sleep= 30;

  public static void main(String args[])
  {
    if (args.length>=1) step= Integer.parseInt(args[0]);
    if (args.length>=2) sleep= Integer.parseInt(args[1]);
    if (args.length>=3) width= Integer.parseInt(args[2]);
    if (args.length>=4) height= Integer.parseInt(args[3]);

    Animator anim= new Animator(width, height, "Animator");
    Grob text= new Text("Texto", Color.black, 10, 10);
    anim.push(text);
    Grob circ= new Ellipse(Color.black, Color.white, 20, 20, 20, 20);
    anim.push(circ);
    Grob elli= new Ellipse(Color.red, Color.green, 20, 20, 30, 10);
    anim.push(elli);
    Grob rect= new Box(Color.black, Color.white, 30, 30, 30, 15);
    anim.push(rect);
    Grob rect2= new Box(Color.black, Color.red, 20, 25, 20, 25);
    anim.push(rect2);

    double textAngle= 2*Math.PI*Math.random();
    double circAngle= 2*Math.PI*Math.random();
    double elliAngle= 2*Math.PI*Math.random();
    double rectAngle= 2*Math.PI*Math.random();
    double rect2Angle= 2*Math.PI*Math.random();
    
    for(int i=1; ; i++)
    {
      textAngle= Mover(text, textAngle);
      circAngle= Mover(circ, circAngle);
      elliAngle= Mover(elli, elliAngle);
      rectAngle= Mover(rect, rectAngle);
      rect2Angle= Mover(rect2, rect2Angle);
      if (i%20==0) anim.bot().raise();
      if (i%90==45) ((Ellipse)circ).setDim(25, 25);
      if (i%90==0) ((Ellipse)circ).setDim(20, 20);
      anim.sleep(sleep);
    }
  }

  public static double Mover(Grob grob, double angle)
  {
    int x= grob.getX();
    int y= grob.getY();
    for (;;)
    {
      int newx= x+ (int)(step*Math.cos(angle));
      int newy= y+ (int)(step*Math.sin(angle));

      if (newx<10 || newx>=width-10 || newy<10 || newy>=height-10)
      {
        angle= 2*Math.PI*Math.random();
        // System.out.println("Bounce "+newx+" "+newy);
      }
      else
      {
        grob.moveTo(newx, newy);
        // System.out.println(grob.getClass().getName()+" en "+newx+","+newy);
        return angle;
  } } }
}
