package Scenes;

import java.awt.*;
import Conc.*;

public class Scene extends Lock
{
  AbsGrob botGrob= new AbsGrob(); // Se usan para que la lista de doble enlace
  AbsGrob topGrob= new AbsGrob(); // nunca este vacia en ningun extremo.
  // Box  paintBox= new Box();
  // Box  extBox= new Box();

  public Scene()
  {
    topGrob.nextGrob= botGrob;
    botGrob.prevGrob= topGrob;

    topGrob.scene= botGrob.scene= this;

    // Estos otros campos no se deberian tocar jamas
    topGrob.prevGrob= botGrob.nextGrob= null;
  }

  // Entrega el objeto del tope
  public final AbsGrob top()
  { 
    lock();
      AbsGrob grob= topGrob.next();
    unlock();
    return grob;
  }

  // Entrega el objeto del final
  public final AbsGrob bot()
  {
    lock();
      AbsGrob grob= botGrob.prev();
    unlock();
    return grob;
  }

  // Entrega el sucesor de un objeto grafico
  public final AbsGrob next(AbsGrob grob)
  {
    lock();
      AbsGrob nextGrob= grob.nextGrob!=botGrob ? grob.nextGrob : null;
    unlock();
    return nextGrob;
  }

  // Entrega el predecesor de un objeto grafico
  public final AbsGrob prev(AbsGrob grob)
  {
    lock();
      AbsGrob prevGrob= grob.prevGrob!=topGrob ? grob.prevGrob : null;
    unlock();
    return prevGrob;
  }

  // agrega insGrob despues de baseGrob
  public final void addAfter(AbsGrob baseGrob, AbsGrob insGrob)
  {
    lock();
      if (insGrob.scene!=null) delete(insGrob);

      insGrob.prevGrob= baseGrob;
      insGrob.nextGrob= baseGrob.nextGrob;

      insGrob.prevGrob.nextGrob= insGrob.nextGrob.prevGrob= insGrob;

      insGrob.scene= this;
    unlock();
  }

  // Inserta insGrob antes de baseGrob
  public final void insertBefore(AbsGrob baseGrob, AbsGrob insGrob)
  {
    lock();
      addAfter(baseGrob.prevGrob, insGrob);
    unlock();
  }

  // Agrega un objeto por arriba
  public final void push(AbsGrob grob)
  {
    addAfter(topGrob, grob);
  }

  // Elimina un objeto grafico
  public final void delete(AbsGrob grob)
  {
    lock();
      AbsGrob prevGrob= grob.prevGrob;
      AbsGrob nextGrob= grob.nextGrob;
      prevGrob.nextGrob= nextGrob;
      nextGrob.prevGrob= prevGrob;

      grob.prevGrob= grob.nextGrob= null;
    unlock();
  }

  // Redibuja todos los objetos graficos en un graphics
  public final void paint(Graphics gr)
  {
    lock();
      for (AbsGrob grob= bot(); grob!=null; grob= grob.prev())
      {
        // if (grob.isOverlapped(paintBox))
        grob.paint(gr);
      }
    unlock();
  }
}
