package Scenes;

import java.awt.Graphics;
import java.awt.Color;

public class Grob extends AbsGrob
{
  int x, y;
  Color fgColor;
  Color bgColor;

  public Grob(Color _fgColor, Color _bgColor, int _x, int _y)
  {
    x= _x;
    y= _y;
    fgColor= _fgColor;
    bgColor= _bgColor;
  }

  // En estas operaciones no vale la pena bloquear la tarea de redibujo
  public void setFgColor(Color newFgColor) { fgColor= newFgColor; }
  public void setBgColor(Color newBgColor) { bgColor= newBgColor; }

  public final int getX() { return x; }
  public final int getY() { return y; }
  public final Color getFgColor() { return fgColor; }
  public final Color getBgColor() { return bgColor; }

  // Estas operaciones si deben bloquear el redibujo, porque no son atomicas
  public void move(int dx, int dy)
  {
    lock();
      x+= dx;
      y+= dy;
    unlock();
  }

  public void moveTo(int _x, int _y)
  {
    lock();
      x= _x;
      y= _y;
    unlock();
  }
}
