package Scenes;

import java.awt.Graphics;
import java.awt.Color;

public class Ellipse extends Grob
{
  int xr, yr;

  public Ellipse(Color _fgColor, int _x, int _y, int _xr, int _yr)
  { this(_fgColor, null, _x, _y, _xr, _yr); }

  public Ellipse(Color _fgColor, Color _bgColor,
                   int _x, int _y, int _xr, int _yr)
  {
    super(_fgColor, _bgColor, _x, _y);
    xr= _xr;
    yr= _yr;
  }

  public void paint(Graphics gr)
  {
    if (bgColor!=null)
    {
      gr.setColor(bgColor);
      gr.fillOval(x-xr, y-yr, xr*2, yr*2);
    }
    if (fgColor!=null)
    {
      gr.setColor(fgColor);
      gr.drawOval(x-xr, y-yr, xr*2, yr*2);
    }
  }

  public final int getXR() { return xr; }
  public final int getYR() { return yr; }

  public final void setDim(int _xr, int _yr)
  {
    lock();
      xr= _xr;
      yr= _yr;
    unlock();
  }
}
