package Scenes;

import java.awt.*;

public class DBCanvas extends Canvas implements Runnable
{
  Scene scene;
  int sleepTime;
  int width, height;

  Thread animatorThread= null;
  Dimension offDim= null;
  Graphics offGr= null;
  Image offImg= null;

  public DBCanvas(Scene _scene, int _sleepTime, int w, int h)
  {
    scene= _scene;
    sleepTime= _sleepTime;
    width= w;
    height= h;
  }

  public void start()
  {
    if (animatorThread==null)
    {
      animatorThread= new Thread(this);
      animatorThread.start();
    }
  }

  public void stop() { animatorThread= null; }

  public void run()
  {
    while (Thread.currentThread() == animatorThread)
    {
      // Display the next frame of animation.
      repaint();

      // Delay
      try
      {
        Thread.sleep(sleepTime);
      } catch (InterruptedException e)
      {
        break;
  } } }

  public void update(Graphics gr)
  {
    Dimension canvasDim= size();

    // System.out.println("update ...");

    if ( offGr == null
         || (canvasDim.width != offDim.width)
         || (canvasDim.height != offDim.height) )
    {
       System.out.println("Canvas width= "+canvasDim.width+
                               ", height= "+canvasDim.height);
       offDim = canvasDim;
       offImg = createImage(canvasDim.width, canvasDim.height);
       offGr  = offImg.getGraphics();
    }

    // Erase the previous image.
    offGr.setColor(getBackground());
    offGr.fillRect(0, 0, offDim.width, offDim.height);

    // Paints the scene
    scene.paint(offGr);
   
    // Paint the image onto the screen.
    gr.drawImage(offImg, 0, 0, this);
  }

  public synchronized void paint(Graphics gr)
  {
    notifyAll();
    if (offImg!=null) gr.drawImage(offImg, 0, 0, this);
  }

  public synchronized void waitPaint()
  {
    try { wait(); }
    catch (InterruptedException e) { }
    start();
  }

  public Dimension minimumSize() { return new Dimension(width,height); }

  public Dimension preferredSize() { return minimumSize(); }
}
