package Scenes;

import java.awt.Graphics;
import java.awt.Color;

public class Box extends Grob
{
  int width, height;

  public Box(Color _fgColor, int _x, int _y, int w, int h)
  { this(_fgColor, null, _x, _y, w, h); }

  public Box(Color _fgColor, Color _bgColor,
                   int _x, int _y, int w, int h)
  {
    super(_fgColor, _bgColor, _x, _y);
    width= w;
    height= h;
  }

  public void paint(Graphics gr)
  {
    if (bgColor!=null)
    {
      gr.setColor(bgColor);
      gr.fillRect(x, y, width, height);
    }
    if (fgColor!=null)
    {
      gr.setColor(fgColor);
      gr.drawRect(x, y, width, height);
    }
  }

  public final int getWidth() { return width; }
  public final int getHeight() { return height; }
  public final void setDim(int w, int h)
  {
    lock();
      width= w;
      height= h;
    unlock();
  }
}
