package Scenes;

import java.awt.*;

public class Animator extends Scene implements Runnable
{
  int width, height;
  String title;
  int sleepTime;

  Thread frameThread;
  DBCanvas canvas;

  public Animator(int _width, int _height, String _title)
  {
    this(_width, _height, _title, 30);
  }

  public Animator(int _width, int _height, String _title, int _sleepTime)
  {
    width= _width;
    height= _height;
    title= _title;
    sleepTime= _sleepTime;
    frameThread= new Thread(this);
    frameThread.start();
    waitFrame();
  }

  public void run()
  {
    System.out.println("creating animFrame ...");

    Frame frame= new Frame(title);
    frame.setLayout(new BorderLayout());

    canvas= new DBCanvas(this, sleepTime, width, height);
    frame.add("Center", canvas);

    System.out.println("packing ...");
    frame.pack();
    frame.show();
    System.out.println("waiting frame ...");
    canvas.waitPaint();
    notifyFrame();
    System.out.println("ok ...");
  }

  public static void sleep(int sleepTime)
  {
    try { Thread.sleep(sleepTime); }
    catch (InterruptedException e) { }
  }

  public final void stop() { canvas.stop(); }

  synchronized void notifyFrame()
  {
    notifyAll();
  }

  synchronized void waitFrame()
  {
    try { wait(); }
    catch (InterruptedException e) { }
  }
}
