package Scenes;

import java.awt.*;

public class AbsGrob // extend Box
{
  Scene  scene= null;  // La escena que contiene este objeto
  AbsGrob nextGrob= null; // Se implementa una lista doblemente enlazada
  AbsGrob prevGrob= null;

  // Constructores
  public AbsGrob() { }

  public AbsGrob(Scene _scene)
  {
    if (scene!=null) scene.push(this);
  }

  // Hay que pasar por scene, porque es el monitor de acceso

  public final AbsGrob next() { return scene.next(this); }
  public final AbsGrob prev() { return scene.prev(this); }

  public final void addAfter(AbsGrob grob) { scene.addAfter(this, grob); }
  public final void insertBefore(AbsGrob grob)
    { scene.insertBefore(this, grob); }
  public final void delete() { scene.delete(this); }
  public final void raise() { scene.addAfter(scene.topGrob, this); }
  public final void lower() { scene.insertBefore(scene.botGrob, this); }

  public final void lock() { if (scene!=null) scene.lock(); }
  public final void unlock() { if (scene!=null) scene.unlock(); }

  // Operaciones para redefinir en cada objeto grafico

  public void paint(Graphics gr) { }   // Invocado por la tarea de redibujo
}
