package ping;

import netobj.*;

public class ConcretePingServer extends ConcreteNetObj implements PingServer {
  public String ping() throws NetException {
    System.out.println("ConcretePingServer.ping");
    return "Hello World!";
  }

  public static void main(String[] args) throws NetException {
    if (args.length!=1) {
      System.err.println("Usage: java ping.ConcretePingServer <socket port>");
      System.exit(1);
    }
       
    Debug.logOnFile("pingserver.log");
    Manager.setSocketPort(Integer.parseInt(args[0]));
    ConcretePingServer server= new ConcretePingServer();
    Manager.bind("pingServer", server);
    System.out.println("pingServer launched");
  }
}
