package netregistry;

import netobj.*;
import java.net.*;

public class Naming {

  public static void bind(String urladdr, NetObj netObj)
      throws MalformedURLException, NetException, UnknownHostException {
    URL url= new URL(urladdr);
    String host= url.getHost();
    int port= url.getPort();
    String objname= url.getFile().substring(1);
    NetRegistry netRegistry= (NetRegistry)Manager.lookup(
                        "http://"+host+":"+port+"/netRegistry");
    netRegistry.bind(objname, netObj);
  }

  public static NetObj lookup(String urladdr)
      throws MalformedURLException, NetException, UnknownHostException {
    URL url= new URL(urladdr);
    String host= url.getHost();
    int port= url.getPort();
    String objname= url.getFile().substring(1);
    NetRegistry netRegistry= (NetRegistry)Manager.lookup(
                        "http://"+host+":"+port+"/netRegistry");
    return netRegistry.lookup(objname);
  }
}
