package netobj;

import java.io.*;

// The objects of the class WireRep are network wide identifiers of
// objects.  This identifiers are formed from the JVM identifier
// (the adress space) and a serial number stamped on any network
// object.

class WireRep implements Serializable {
  Space sp= null; // The JVM process owner of the represented network object  
  long id;  // The object identification within the JVM process
  String stubClassName;

  WireRep() {
  }

  WireRep(Space sp, long id, String stubClassName) {
    this.sp= sp;
    this.id= id;
    this.stubClassName= stubClassName;
  }

  // This is for using a wire rep as the key in a hash table
  public int hashCode() {
    return (int)(sp.hashCode()+id);
  }
  public boolean equals(Object obj) {
    try {
      WireRep wrep= (WireRep)obj;
      return sp.equals(wrep.sp) && id==wrep.id;
    }
    catch (ClassCastException excp) {
      return false;
    }
  }
  // When reading from an object input stream, if a wire rep is found
  // it is replaced by the equivalent network object (the stub or
  // the concrete network object).
  Object readResolve() throws ObjectStreamException {
    Object obj;
    try {
      obj= Manager.manager.receiveNetObj(this);
      return obj;
    }
    catch (NetException excp) {
      System.err.println("WireRep: couldn't resolve network object");
      throw
        new InvalidObjectException("WireRep: couldn't resolve network object");
    }
  }
  public String toString() {
    return sp.toString()+"/"+id;
  }
}
