package netobj;

import java.io.*;
import java.net.*;

// The objects of the class Space identify uniquely a JVM process.
// The identification is formed from the IP number of the machine where
// the JVM runs and the port number where the process listens to requests
// of new connections for that JVM.

class Space implements Serializable {
  InetAddress iaddr; // The processor identifier
  int port;          // a port to communicate with the JVM process

  Space(InetAddress iaddr, int port) {
    this.iaddr= iaddr;
    this.port= port;
  }

  // This is just to be able to use space objects as the keys
  // in hash tables.
  public int hashCode() {
    return iaddr.hashCode()+port;
  }
  public boolean equals(Object obj) {
    try {
      Space sp= (Space)obj;
      return iaddr.equals(sp.iaddr) && port==sp.port;
    }
    catch (ClassCastException excp) {
      return false;
    }
  }
  public String toString() {
    return iaddr.getHostName()+"("+iaddr.getHostAddress()+"):"+port;
  }
}
