package netobj;

import java.io.*;

public class Debug {
  private static Manager manager= Manager.getLocalManager();
  private static boolean debug= false;
  private static PrintWriter out= null;

  public static void traceObjTbl(int millis) {
    final int millis2= millis;
    new Thread(new Runnable() {
        public void run() {
          try {
            Runtime rt= Runtime.getRuntime();
            for (;;) {
              long oldmem= rt.freeMemory();
              rt.gc();
              manager.traceObjTbl();
              System.err.println("GC memory (before/after)= "+
                     oldmem/1024+"/"+rt.freeMemory()/1024+" kb");
              Thread.sleep(millis2);
            }
          }
          catch (InterruptedException excp) {
            System.err.println("Debug: Interrupted Exception");
          }
        }
      }).start();
  }

  public static void prt(String msg) {
    if (debug) {
      out.println(msg);
      out.flush();
    }
  }

  public static void logOnFile(String name) {
    Debug.debug= true;
    try {
      out= new PrintWriter(new BufferedWriter(new FileWriter(name)));
    }
    catch (IOException excp) {
      System.err.println("Debug: can't open log file.");
    }
  }
}
