package netobj;

import java.io.*;

class ConcreteRegistrySkel extends ConcreteNetObjSkel {
  final static int Export= 1;
  final static int Import= 2;

  public void dispatch(ObjectInputStream in, ClientConnection client,
                       ConcreteNetObj netObj, int methodId)
                       throws IOException, ClassNotFoundException {
    ConcreteRegistry registry= (ConcreteRegistry)netObj;
    switch(methodId) {
      case Export: {
        String name= (String)in.readObject();
        NetObj exportedNetObj= (NetObj)in.readObject();
        client.checkTag();
        try {
          registry.bind(name, exportedNetObj);
        }
        catch (Exception excp) {
          client.remoteRetException(excp);
          return;
        }
        client.remoteRetVoid();
        return;
      }
      case Import: {
        String name= (String)in.readObject();
        client.checkTag();
        Object obj;
        try {
          obj= registry.lookup(name);
        }
        catch (Exception excp) {
          client.remoteRetException(excp);
          return;
        }
        client.remoteRetObject(obj);
        return;
      }
    }
    super.dispatch(in, client, netObj, methodId);
  }
}
