package netobj;

import java.util.*;

public class ConcreteRegistry extends ConcreteNetObj implements Registry {
  private Manager manager= Manager.getLocalManager();

  private Map objTbl= new HashMap();

  ConcreteRegistry() {
    Space selfSp= manager.selfSpace();
    wrep= new WireRep(selfSp, 0, "netobj.ConcreteRegistryStub");
    skel= new ConcreteRegistrySkel();
    manager.sendNetObj(this); // Places the registry in the object table
    clientSet.add(selfSp);
      // This a trick to avoid that the registry leaves the object table
      // when the distributed GC will be working.
    Debug.prt("ConcreteRegistry: created");
  }

  // bind: export (or re-export) the network object netobj.  The object
  // will be named as objname.
  public synchronized void bind(String name, NetObj netObj)
         throws NetException {
    Debug.prt("ConcreteRegistry: binding "+
                       netObj+" to "+name);
    objTbl.put(name, netObj);
  }
  // lookup: get a reference of a named remote network object.  The
  // string urladdr must be `netobj://<host>:<port>/<objname>'.
  public synchronized NetObj lookup(String name) throws NetException {
    NetObjBase netObj= (NetObjBase)objTbl.get(name);
    if (netObj==null)
      Debug.prt("ConcreteRegistry: looking for "+name+" -> failed");
    else
      Debug.prt("ConcreteRegistry: looking for "+name+" -> "+netObj);
    return netObj;
  }
}
