package netobj;

import java.io.*;

// ConcreteNetObjStub: the base class for all stubs.  It provides methods
// to perform the remote calls.

public abstract class ConcreteNetObjStub extends NetObjBase {

  private ServerConnection server;

  // finalize: invoked by the local garbage collector when the stub
  // is no longer reachable in the local space.
  public void finalize() {
    Manager.manager.finalizeStub(this);
  }

  // init: invoked immediately after creation to initialize the stub.
  // (placing this inicialization in the constructor would be troublesome).
  void init(WireRep wrep, ServerConnection server) {
    this.wrep= wrep;
    this.server= server;
  }

  // For the explanation of the following methods see
  // the class ServerConnection

  public ObjectOutputStream startRemoteCall(int methodId) throws NetException {
    return server.startRemoteCall(wrep, methodId);
  }

  public void waitRemoteRetVoid() throws NetException {
    server.waitRemoteRetVoid(wrep);
  }

  public int waitRemoteRetInt() throws NetException {
    return server.waitRemoteRetInt(wrep);
  }

  public double waitRemoteRetDouble() throws NetException {
    return server.waitRemoteRetDouble(wrep);
  }

  public boolean waitRemoteRetBoolean() throws NetException {
    return server.waitRemoteRetBoolean(wrep);
  }

  public Object waitRemoteRetObject() throws NetException {
    return server.waitRemoteRetObject(wrep);
  }

  public void throwNetException(Exception excp) throws NetException {
    server.throwNetException(excp);
  }
}
