package irc;

import netobj.*;
import java.io.*;

public class IrcWriter {
  public static void main(String[] args) throws Exception {
    if (args.length!=2) {
      System.err.println(
        "Usage: java irc.IrcWriter <host>:<port> <user>");
      System.exit(1);
    }
    
    Debug.logOnFile("ircwriter.log");
    String url= "http://"+args[0]+"/ircServer";
    String name= args[1];
    Debug.prt("looking for "+url);
    IrcServer server= (IrcServer)Manager.lookup(url);

    System.out.print(url+" got.\n");
    server.put("User "+name+" has connected");
    BufferedReader in= new BufferedReader(new InputStreamReader(System.in), 1);
    while(true) {
      System.out.print("? ");
      String lin= in.readLine();
      if (lin==null)
        break;
      server.put("From "+name+": "+lin);
    }
    System.exit(0);
  }
}
