package irc;

import netobj.*;

public class IrcReader {
  public static void main(String[] args) throws Exception {
    if (args.length!=1) {
      System.err.println("Usage: java irc.IrcReader <host>:<port>");
      System.exit(1);
    }

    Debug.logOnFile("ircreader.log");
    String url= "http://"+args[0]+"/ircServer";
    Debug.prt("looking for "+url);
    IrcServer server= (IrcServer)Manager.lookup(url);

    int serial= server.getSerial();
    System.out.println(url+" got.  Next message will have id "+serial);
    while(true) {
      String lin= server.get(serial);
      if (lin==null)
        System.out.println("message lost");
      else
        System.out.println(lin);
      serial++;
    }
  }
}
