package irc;

import netobj.*;

public class ConcreteIrcServer extends ConcreteNetObj
                       implements IrcServer {
  static final int size= 10;
  String[] buff= new String[size];
  int serial= 0;

  // put: post the message `text'.  A serial identifier is assigned to
  // the message so readers can read it.  put Memorize last 10 messages.
  // If a client tries to read a message older than the last 10 messages,
  // it gets null.
  public synchronized void put(String text) throws NetException {
    buff[serial%size]= text;
    System.out.println(serial+": "+text);
    serial++;
    notifyAll();
  }

  // get: get the message with identifier `serial'.
  public synchronized String get(int serial) throws NetException {
    try {
      while (this.serial<=serial)
        wait();
      if (this.serial-serial>size)
        return null; // mensaje perdido
      else
        return buff[serial%size];
    }
    catch (InterruptedException e) {
      System.out.println("Interrupted exception");
      return null;
    }
  }

  // getSerial: get the serial identifier of the last message posted.
  public synchronized int getSerial() throws NetException {
    System.out.println("got serial id "+serial);
    return serial;
  }

  // main: launch the irc server.
  public static void main(String[] args) throws NetException {
    if (args.length!=1) {
      System.err.println("Usage: java irc.ConcreteIrcServer <socket port>");
      System.exit(1);
    }

    Debug.logOnFile("ircserver.log");
    Manager.setSocketPort(Integer.parseInt(args[0]));
    ConcreteIrcServer server= new ConcreteIrcServer();
    Manager.bind("ircServer", server);
    System.out.println("ircServer registered");
  }
}
