package factory;

import ping.*;
import netobj.*;
import java.net.*;

public class MultiPing {
  static Factory factory;
  public static void main(String[] args)
         throws Exception {
    if (args.length!=2) {
      System.err.println(
        "Usage: java ping.MultiPing <host>:<port> <thread count>");
      System.exit(1);
    }

    Debug.logOnFile("multiping.log");
    String url= "http://"+args[0]+"/pingServerFactory";
    int threadCount= Integer.parseInt(args[1]);
    Debug.prt("looking for "+url);
    factory= (Factory)Manager.lookup(url);
    Debug.traceObjTbl(10000);
    for (int i= 0; i<threadCount; i++) {
      new Thread(new Runnable() {
          public void run() {
            Debug.prt("Thread launched");
            try {
              for(;;) {
                PingServer pingServer= factory.makePingServer();
                System.out.println(pingServer.ping());
              }
            }
            catch (NetException excp) {
              excp.printStackTrace();
            }
          }
        }).start();
    }
  }
}
