package factory;

import netobj.*;
import ping.*;

public class ConcreteFactory extends ConcreteNetObj implements Factory {
  public PingServer makePingServer() throws NetException {
    Debug.prt("ConcreteFactory: making PingServer");
    return new ConcretePingServer();
  }

  public static void main(String[] args) throws NetException {
    if (args.length!=1) {
      System.err.println("Usage: java ping.ConcreteFactory <socket port>");
      System.exit(1);
    }

    Debug.logOnFile("factory.log");
    Manager.setSocketPort(Integer.parseInt(args[0]));
    ConcreteFactory factory= new ConcreteFactory();
    Manager.bind("pingServerFactory", factory);
    System.out.println("pingServerFactory launched");
    Debug.traceObjTbl(10000);
  }
}
