package buff;

import netobj.*;
import java.io.*;

public class ConcreteBufferSkel extends ConcreteNetObjSkel {
  final static int Put= 1;
  final static int Get= 2;

  public void dispatch(ObjectInputStream in, ClientConnection client,
                       ConcreteNetObj netObj, int methodId)
                       throws IOException, ClassNotFoundException {
    ConcreteBuffer server= (ConcreteBuffer)netObj;
    switch(methodId) {
      case Put: {
        Object o= (Object)in.readObject();
        client.checkTag();
        try {
          server.put(o);
        }
        catch (Exception excp) {
          client.remoteRetException(excp);
          return;
        }
        client.remoteRetVoid();
        return;
      }
      case Get: {
        client.checkTag();
        Object o= null;
        try {
          o= server.get();
        }
        catch (Exception excp) {
          client.remoteRetException(excp);
          return;
        }
        client.remoteRetObject(o);
        return;
      }
    }
    super.dispatch(in, client, netObj, methodId);
  }
}
