#include "nSystem.h"
#include "nSysimp.h"

#define CATEGORIAS 2
Queue tareas_cat[CATEGORIAS];


int ocup = -1; //-1 libre
int cnt[2] = {0, 0};


void pedirInit() {  
 START_CRITICAL();
  for (int i = 0; i < CATEGORIAS; i++){
    tareas_cat[i] = MakeQueue(); 
  }
  END_CRITICAL();
}

void nPedir(int cat) {
  START_CRITICAL(); //Entramos en una sección crítica
  if (ocup == -1){
    ocup = cat;
  }
  
  else { //si se están ocupando los recursos:
    current_task->status = WAIT_PEDIR; //indico que me toca esperar
    cnt[cat]++;
    PutTask(tareas_cat[cat], current_task); // me meto a la fila de mi categoría
    ResumeNextReadyTask(); 
  }

  END_CRITICAL();
}

void nDevolver() {
  START_CRITICAL();

  // Caso hay threads de la categoría opuesta
  if (cnt[!ocup] > 0){
    nTask tarea_extraida = GetTask(tareas_cat[!ocup]); //obtiene la tarea
    cnt[!ocup]--;
    ocup = !ocup; //cambia el tipo
  
    //asegúrate que la tarea haya estado en WAIT_PEDIR
    if (tarea_extraida->status == WAIT_PEDIR){
      tarea_extraida->status = READY;
      PushTask(ready_queue, tarea_extraida); //pone la tarea_extraida como lista
      ResumeNextReadyTask(); //deja pasar a la siguiente tarea.
    }

  }

  // Caso hay threads de la misma categoría
  else if (cnt[ocup] > 0){
    nTask tarea_extraida = GetTask(tareas_cat[ocup]); //obtiene la tarea
    cnt[ocup]--;
    //asegúrate que la tarea haya estado en WAIT_SLEEP
    if (tarea_extraida->status == WAIT_PEDIR){
      tarea_extraida->status = READY;
      PushTask(ready_queue, tarea_extraida); //pone la tarea_extraida como lista
      ResumeNextReadyTask(); //deja pasar a la siguiente tarea.
    }

  }

  else {
    ocup = -1; //Setea el ocupado como libre
  }
  END_CRITICAL();
}

// ~/SOs/psystem64-alfa2$ 