#define _DEFAULT_SOURCE 1
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <nSystem.h>

static int verbose= FALSE;

// ==================================================
// Para los tests unitarios en modo non preemptive
//

static int tiempo_actual= 1; /* en centesimas de segundo */

static nMonitor t_mon;

static void iniciar() {
  nEnter(t_mon);
  tiempo_actual= 1;
  nExit(t_mon);
}

static int tiempoActual() {
  nEnter(t_mon);
  int t= tiempo_actual;
  nExit(t_mon);
  return t;
}

static void pausa(int tiempo_espera) {
  nEnter(t_mon);
  int tiempo_inicio= tiempo_actual;
  nExit(t_mon);
  nSleep(tiempo_espera*300);
  nEnter(t_mon);
  tiempo_actual= tiempo_inicio+tiempo_espera;
  nExit(t_mon);
}

// ==================================================
// Chequeo de entradas y salidas
//

#define RECUERDO "\nEste test puede fallar con una solucion correcta si\n" \
                 "el proceso no recibe la CPU durante 0.3 segundos.\n" \
                 "Intente terminar procesos que puedan gastar CPU como\n" \
                 "por ejemplo el navegador.  Si con esto no se resuelve el\n" \
                 "problema, es porque su solucion es incorrecta.\n"

static void chkIn(int t, int tref, char *nom) {
  if (t!=tref) {
    nFatalError("chkIn",
         "Tiempo de entrada incorrecto de %s.  Es %d y debio ser %d.\n"
         RECUERDO,
         nom, t, tref);
  }
}

static void chkOut(int t, int tref, char *nom) {
  if (t!=tref) {
    nFatalError("chkIn",
         "Tiempo de salida incorrecto de %s.  Es %d y debio ser %d.\n"
         RECUERDO,
         nom, t, tref);
  }
}

// ==================================================
// Solicitud de entrada y devolucion
//

static int leyendo= FALSE;

static int solicitar(char *nom, int tref) {
  if (verbose)
    nPrintf("%d: %s solicita mutex\n", tiempoActual(), nom);

  nLock();
  
  int t= tiempoActual();
  if (verbose)
    nPrintf("%d: %s obtiene mutex\n", t, nom);

  if (leyendo)
    nFatalError("solicitar",
                "no se respeta exclusion mutua al otorgar mutex\n");
  leyendo= TRUE;
  chkIn(t, tref, nom);
  return t;
}

static int devolver(char *nom, int tref) {
  leyendo= FALSE;
  int t= tiempoActual();
  if (verbose)
    nPrintf("%d: %s libera mutex\n", t, nom);
  chkOut(t, tref, nom);
  nUnlock();
  return t;
}

// ==================================================
// Comportamiento de los threads
//

static int pedro_fun() {
  char *nom= "Pedro";
  solicitar(nom, 1);
  pausa(1);
  devolver(nom, 2);
  pausa(5);
  solicitar(nom, 8);
  pausa(1);
  devolver(nom, 9);
  pausa(2);
  solicitar(nom, 13);
  pausa(1);
  devolver(nom, 14);
  return 0;
}

static int juan_fun() {
  char *nom= "Pedro";
  pausa(2);
  solicitar(nom, 3);
  pausa(2);
  devolver(nom, 5);
  pausa(1);
  solicitar(nom, 9);
  pausa(3);
  devolver(nom, 12);
  return 0;
}

static int diego_fun() {
  char *nom= "Diego";
  pausa(3);
  solicitar(nom, 5);
  pausa(3);
  devolver(nom, 8);
  pausa(2);
  solicitar(nom, 12);
  pausa(1);
  devolver(nom, 13);
  return 0;
}

static void unitTest() {
  nPrintf("\n");
  nPrintf("===============================\n");
  nPrintf("Test unitarios\n");
  nPrintf("===============================\n\n");
  nSetTimeSlice(0);
  verbose= TRUE;
  iniciar();

  // nTask pedro, juan, diego, paco, maria, ana, silvia, sonia;
  nTask pedro, juan, diego;

  pedro= nEmitTask(pedro_fun);
  juan= nEmitTask(juan_fun);
  diego= nEmitTask(diego_fun);
  
  nWaitTask(pedro);
  nWaitTask(juan);
  nWaitTask(diego);

  nPrintf("Aprobado\n");
}

// ==================================================
// Para el test de robustez en modo non preemptive
//

#ifndef VALGRIND

#define NTASKS 1000
#define ITER 2000
#define OCUP 100

#else

#define NTASKS 100
#define ITER 200
#define OCUP 100

#endif

static int dentro= 0;

static int robustez_fun(int n) {
  for (int k= 0; k<n; k++) {
    nLock();
    if (dentro==1)
      nFatalError("test", "No se cumple la exclusion mutua\n");
    dentro= 1;
    for (int i=0; i<OCUP; i++)
      ;
    dentro= 0;
    nUnlock();
  }
  return 0;
}

static void testRobustez() {
  nPrintf("\nTest de robustez\n");
  nPrintf("----------------\n\n");
  nSetTimeSlice(1);
  nTask *tasks= nMalloc(NTASKS*sizeof(nTask));
  for (int i= 0; i<NTASKS; i++)
    tasks[i]= nEmitTask(robustez_fun, ITER);
  for (int i= 0; i<NTASKS; i++)
    nWaitTask(tasks[i]);

  nFree(tasks);
  nPrintf("Aprobado\n");
}

int nMain() {
  t_mon= nMakeMonitor();

  unitTest();

  testRobustez();

  nDestroyMonitor(t_mon);

  nPrintf("Felicitaciones: paso todos los tests.\n");

  return 0;
}
