// Estas son las funciones que Ud. debe programar en mutex.c

void MutexInit();
void lock();
void unlock();

// Ud. debe usar el tipo SpinLock y las funciones de mas abajo
//

#define NCORES 32

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

typedef struct {
  int busy;
  struct nMonitor *m;
} SpinLock;
    
enum { OPEN, CLOSED };
    
void initSpinLock(SpinLock *psl, int ini);
void destroySpinLock(SpinLock *psl);
void spinLock(SpinLock *psl);
void spinUnlock(SpinLock *psl);

int coreId();

// Encabezados para la cola de prioridades

typedef struct priqueue *PriQueue;

PriQueue MakePriQueue();
void DestroyPriQueue();
void *PriGet(PriQueue pq);
void PriPut(PriQueue pq, void* t, int pri);
int PriSize(PriQueue pq);
int PriBest(PriQueue pq);
int EmptyPriQueue(PriQueue pq);
int PriLength(PriQueue pq);
