#include <nSystem.h>
#include "nSysimp.h"

// Encabezados para la cola de prioridades

typedef struct priqueue *PriQueue;

PriQueue MakePriQueue();
void DestroyPriQueue();
void *PriGet(PriQueue pq);
void PriPut(PriQueue pq, void* t, int pri);
int PriSize(PriQueue pq);
int PriBest(PriQueue pq);
int EmptyPriQueue(PriQueue pq);
int PriLength(PriQueue pq);

// Defina aca las variables globales que necesite

...

// Programe aca las funciones nLock y nUnlock
// y otras funciones si las necesita

#define Resume ResumeNextReadyTask

void MutexInit() {
  ...
}

void nLock() {
  ...
}

void nUnlock() {
  ...
}

// Implementacion de la cola de prioridades: dada

#define MAXQSZ 1000

struct priqueue {
  void **vec;
  int *ofertas;
  int size, maxsize;
};

PriQueue MakePriQueue() {
  PriQueue pq= nMalloc(sizeof(*pq));
  pq->maxsize= MAXQSZ;
  pq->vec= nMalloc(sizeof(void*)*(pq->maxsize+1));
  pq->ofertas= nMalloc(sizeof(int)*(pq->maxsize+1));
  pq->size= 0;
  return pq;
}

void DestroyPriQueue(PriQueue pq) {
  if (pq->size!=0)
    nFatalError("DestroyPriQueue", "La cola de prioridad no esta vacia\n");
  nFree(pq->vec);
  nFree(pq->ofertas);
  nFree(pq);
}

void *PriGet(PriQueue pq) {
  void *t;
  int k;
  if (pq->size==0)
    return NULL;
  t= pq->vec[0];
  pq->size--;
  for (k= 0; k<pq->size; k++) {
    pq->vec[k]= pq->vec[k+1];
    pq->ofertas[k]= pq->ofertas[k+1];
  }
  return t;
}

void PriPut(PriQueue pq, void *t, int oferta) {
  if (pq->size==pq->maxsize)
    nFatalError("PriPut", "Desborde de la cola de prioridad\n");
  int k;
  for (k= pq->size-1; k>=0; k--) {
    if (oferta > pq->ofertas[k])
      break;
    else {
      pq->vec[k+1]= pq->vec[k];
      pq->ofertas[k+1]= pq->ofertas[k];
    }
  }
  pq->vec[k+1]= t;
  pq->ofertas[k+1]= oferta;
  pq->size++;
}

int PriSize(PriQueue pq) {
  return pq->size;
}

int PriBest(PriQueue pq) {
  return pq->size==0 ? 0 : pq->ofertas[0];
}

int EmptyPriQueue(PriQueue pq) {
  return pq->size==0;
}

int PriLength(PriQueue pq) {
  return pq->size;
}
