#define _DEFAULT_SOURCE
#include <stdio.h>
#include <nSystem.h>
#include <fifoqueues.h>
#include <string.h>
#include <stdlib.h>

#include "disco.h"

#define TICK 1000

// Test Simple

static int fdama(char *nom, char **ppareja) {
  nPrintf("%s espera pareja\n", nom);
  *ppareja= dama(nom);
  if (*ppareja==NULL)
    nFatalError("fdama", "La pareja de %s es NULL\n", nom);
  nPrintf("La pareja de %s es %s\n", nom, *ppareja);
  return 0;
}

static int fvaron(char *nom, char **ppareja) {
  nPrintf("%s espera pareja\n", nom);
  *ppareja= varon(nom);
  if (*ppareja==NULL)
    nFatalError("fvaron", "La pareja de %s es NULL\n", nom);
  nPrintf("La pareja de %s es %s\n", nom, *ppareja);
  return 0;
}

static void verificar_pareja(char *nom_dama, char *nom_varon,
                      char *pareja_dama, char *pareja_varon) {
  if (strcmp(pareja_dama, nom_varon)!=0)
    nFatalError("verificar_pareja", "La pareja de %s debio ser %s, "
                "pero es %s\n", nom_dama, nom_varon, pareja_dama);
  if (strcmp(pareja_varon, nom_dama)!=0)
    nFatalError("verificar_pareja", "La pareja de %s debio ser %s, "
                "pero es %s\n", nom_varon, nom_dama, pareja_varon);
}

static void testSimple() {
  nPrintf("Test: una sola pareja, adan y eva\n");
  char *pareja_eva= NULL, *pareja_adan= NULL;
  nTask eva= nEmitTask(fdama, "eva", &pareja_eva);
  nSleep(TICK);
  if (pareja_eva!=NULL)
    nFatalError("testSimple", "eva tenia que esperar a adan\n");
  nTask adan= nEmitTask(fvaron, "adan", &pareja_adan);
  nWaitTask(eva);
  nWaitTask(adan);
  verificar_pareja("eva", "adan", pareja_eva, pareja_adan);
  nPrintf("Aprobado\n");

  nPrintf("Test: el ejemplo del enunciado\n");
  char *pareja_ana= NULL, *pareja_sara= NULL, *pareja_alba= NULL;
  char *pareja_pedro= NULL, *pareja_juan= NULL, *pareja_diego= NULL;
  nTask ana= nEmitTask(fdama, "ana", &pareja_ana);
  nSleep(TICK);
  nTask sara= nEmitTask(fdama, "sara", &pareja_sara);
  nSleep(TICK);
  nTask pedro= nEmitTask(fvaron, "pedro", &pareja_pedro);
  nSleep(TICK);
  nTask juan= nEmitTask(fvaron, "juan", &pareja_juan);
  nSleep(TICK);
  nTask diego= nEmitTask(fvaron, "diego", &pareja_diego);
  nSleep(TICK);
  nTask alba= nEmitTask(fdama, "alba", &pareja_alba);
  nWaitTask(sara);
  nWaitTask(juan);
  nWaitTask(ana);
  nWaitTask(pedro);
  nWaitTask(alba);
  nWaitTask(diego);
  if (strcmp(pareja_ana,"pedro")==0 && strcmp(pareja_pedro, "ana")!=0)
    nFatalError("simpleTest", "Inconsitencia de pareja en ana y pedro\n");
  if (strcmp(pareja_ana,"juan")==0 && strcmp(pareja_juan, "ana")!=0)
    nFatalError("simpleTest", "Inconsitencia de pareja en ana y juan\n");
  if (strcmp(pareja_ana,"diego")==0 && strcmp(pareja_diego, "ana")!=0)
    nFatalError("simpleTest", "Inconsitencia de pareja en ana y diego\n");

  if (strcmp(pareja_sara,"pedro")==0 && strcmp(pareja_pedro, "sara")!=0)
    nFatalError("simpleTest", "Inconsitencia de pareja en sara y pedro\n");
  if (strcmp(pareja_sara,"juan")==0 && strcmp(pareja_juan, "sara")!=0)
    nFatalError("simpleTest", "Inconsitencia de pareja en sara y juan\n");
  if (strcmp(pareja_sara,"diego")==0 && strcmp(pareja_diego, "sara")!=0)
    nFatalError("simpleTest", "Inconsitencia de pareja en sara y diego\n");

  if (strcmp(pareja_alba,"pedro")==0 && strcmp(pareja_pedro, "alba")!=0)
    nFatalError("simpleTest", "Inconsitencia de pareja en alba y pedro\n");
  if (strcmp(pareja_alba,"juan")==0 && strcmp(pareja_juan, "alba")!=0)
    nFatalError("simpleTest", "Inconsitencia de pareja en alba y juan\n");
  if (strcmp(pareja_alba,"diego")==0 && strcmp(pareja_diego, "alba")!=0)
    nFatalError("simpleTest", "Inconsitencia de pareja en alba y diego\n");

  nPrintf("Aprobado\n");
}

// Test de robustez

#ifdef VALGRIND
#define NPAREJAS 25
#define NBAILES 50
#else
#ifdef DRD
#define NPAREJAS 20
#define NBAILES 25
#else
#define NPAREJAS 50
#define NBAILES 2000
#endif
#endif

static nSem anotadas[NPAREJAS], verificadas[NPAREJAS];
static int pareja_damas[NPAREJAS];
static nTask tasks_damas[NPAREJAS], tasks_varones[NPAREJAS];
static char *noms[NPAREJAS];

int loop_dama(char *nom, int iter) {
  int id= atoi(nom);
  while (iter--) {
    char *pareja= dama(nom);
    int id_pareja= atoi(pareja);
    pareja_damas[id]= id_pareja;
    nSignalSem(anotadas[id]);
    nWaitSem(verificadas[id]);
    pareja_damas[id]= -1;
  }
  return 0;
}

static int loop_varon(char *nom, int iter) {
  int id= atoi(nom);
  while (iter--) {
    char *pareja= varon(nom);
    int id_pareja= atoi(pareja);
    nWaitSem(anotadas[id_pareja]);
    if (pareja_damas[id_pareja]!=id)
      nFatalError("loop_varon", "Varon %s dice que su pareja es dama %s, "
                                "pero dama %s dice que su pareja es varon %d\n",
                  nom, pareja, pareja, pareja_damas[id_pareja]); 
    nSignalSem(verificadas[id_pareja]);
  }
  return 0;
}

static void testRobustez() {
  nPrintf("Test: robustez\n");
  nSetTimeSlice(1);
  for (int i= 0; i<NPAREJAS; i++) {
    anotadas[i]= nMakeSem(0);
    verificadas[i]= nMakeSem(0);
    pareja_damas[i]= -1;
    noms[i]=nMalloc(16);
    sprintf(noms[i], "%d", i);
    int check= atoi(noms[i]);
    if (check!=i)
      nFatalError("testRobustez", "check");
    tasks_damas[i]= nEmitTask(loop_dama, noms[i], NBAILES);
    tasks_varones[i]= nEmitTask(loop_varon, noms[i], NBAILES);
  }
  for (int i= 0; i<NPAREJAS; i++) {
    nWaitTask(tasks_damas[i]);
    nWaitTask(tasks_varones[i]);
  }
  for (int i= 0; i<NPAREJAS; i++) {
    nFree(noms[i]);
    nDestroySem(anotadas[i]);
    nDestroySem(verificadas[i]);
  }
  nPrintf("Aprobado\n");
}

int nMain() {
  DiscoInit();
  testSimple();
  testRobustez();
  DiscoDestroy();
  nPrintf("Felicitaciones: aprobo todos los tests\n");
  return 0;
}

// =================================================
// Implemantacion de spin-locks
// =================================================

// No son verdaderos spinLocks, pero son funcionalmente equivalentes

void initSpinLock(SpinLock *psl, int ini) {
  psl->busy= ini;
  psl->m= nMakeMonitor();
}

void destroySpinLock(SpinLock *psl) {
  nDestroyMonitor(psl->m);
}

void spinLock(SpinLock *psl) {
  nEnter(psl->m);
  while (psl->busy==1)
    nWait(psl->m);
  psl->busy= 1;
  nExit(psl->m);
}

void spinUnlock(SpinLock *psl) {
  nEnter(psl->m);
  psl->busy= 0;
  nNotifyAll(psl->m);
  nExit(psl->m);
}
