#include "nSystem.h"

/***********************************************************************
 * testmutex.c: Programa de prueba para la tarea 2 de CC41B,
 *              semestre Primavera 2002.
 * Autor: Luis Mateu.
 ***********************************************************************/
 
/* Si 'aprobado' logra mantenerse en TRUE durante toda la ejecucion,
 * quiere decir que todos los tests fueron exitosos.
 */
int aprobado= TRUE;

/* Invoca a nSleep para dormir durante 'pausa' milisegundos */

void dormir(int pausa) {
  int ini= nGetTime();
  int duracion;
  nSleep(pausa);
  duracion= nGetTime()-ini;
  if (duracion<pausa) {
    nPrintf("Algo no funciona bien, dormir(%d) tomo solo %d milisegs.\n",
            pausa, duracion);
    aprobado= FALSE;
  }
}

/* Gasta CPU durante 'delta' milisegundos sin estados de espera */

void trabajar(int delta) {
  volatile int k;
  int ini= nGetTime();
  while (nGetTime()-ini<delta)
    for (k= 0; k<10000; k++)
      ;
}

/***************************************************
 * Validacion de la prioridad: una tarea de mejor
 * prioridad no debe dar oportunidad a que una tarea
 * de peor prioridad se ejecute.
 ***************************************************/

int MejorPri(int *pfin) {
  nSetTaskName("MejorPri");
  nPrintf("MejorPri lanzada\n");
  trabajar(10);
 
  *pfin= TRUE;
  nPrintf("MejorPri terminada\n");
}

int ValidarMejorPrioridad() {
  int k;
  volatile int fin= FALSE;
  nTask t;
 
  nPrintf("************************************\n");
  nPrintf("Validando el sistema de prioridades.\n");
  nPrintf("************************************\n");

  nSetTimeSlice(1);
  nSetPriority(0);
  t= nEmitTask(MejorPri, &fin);
  nSetPriority(3);
  k= 0;
  while (!fin)
    k++;
 
  if (k==0)
    nPrintf("Test aprobado.\n");
  else {
    nPrintf("Una tarea con peor prioridad le gano a una de mejor prioridad\n");
    nPrintf("(k= %d).\n", k);
    aprobado= FALSE;
  }
  nWaitTask(t);
  return 0;
}
 
/***********************************************
 * Validacion de una prioridad: tareas de igual
 * prioridad deben tener la misma oportunidad de
 * ejecutarse.
 ***********************************************/

int TestProcA(int pri, int *pini, int *pfin, int *pfinA) {
  nSetTaskName("TestProc0");
  nSetPriority(pri);
  *pini= TRUE;
  nPrintf("TestProcA lanzada.\n");
  trabajar(100);
  *pfin= TRUE;
  while (!pfinA)
    ;
  return 0;
}

/* Este procedimiento termina si y solo si la prioridad efectiva de la tarea que
 * lo invoca es exactamente pri.  De otra forma se queda en un ciclo infinito.
 */

void ValidarPrioridadIgualA(int pri) {
  volatile int ini= FALSE, fin= FALSE, finA= FALSE;
  nTask t;

  nPrintf("Validando la prioridad.  Si se queda en un ciclo quiere decir\n");
  nPrintf("que probablemente no se recalcula bien la prioridad efectiva\n");
  nPrintf("despues de un nRelease.\n");

  t= nEmitTask(TestProcA, pri, &ini, &fin, &finA);
  while (!fin)
    ;
  trabajar(10);
  finA= TRUE;
  nWaitTask(t);
  nPrintf("Prioridad validada.\n");
}

/***********************************************
 * Validacion de la exclusion mutua
 ***********************************************/

#define EXITO 0
#define FRACASO 1
#define LIBRE 0
#define TOMADO 1

int TestProc1(nMutex mutex, int pausa, int* pverif) {
  int rc= EXITO;
  nRequest(mutex);
  if (*pverif==TOMADO)
    rc= FRACASO;
  *pverif= TOMADO;
  dormir(pausa);
  *pverif= LIBRE;
  nRelease(mutex);
  return rc;
}

void ValidarExclusionMutua() {
  nTask t1, t2, t3;
  int pausa= 100;
  int ini= nGetTime();
  int duracion;
  int verif= LIBRE;
  int fracaso;
  nMutex mutex= nMakeMutex();

  nPrintf("*******************************************************\n");
  nPrintf("Test de exclusion mutua: Si se pide el mismo mutex, las\n");
  nPrintf("tareas se deben excluir mutuamente.\n");
  nPrintf("*******************************************************\n");

  nSetTimeSlice(0);
  t1= nEmitTask(TestProc1, mutex, pausa, &verif);
  t2= nEmitTask(TestProc1, mutex, pausa, &verif);
  t3= nEmitTask(TestProc1, mutex, pausa, &verif);
  fracaso= nWaitTask(t1) || nWaitTask(t2) || nWaitTask(t3);
  duracion= nGetTime()-ini;
  nPrintf("duracion= %d\n", duracion);
  if ( fracaso || duracion<pausa*3 ) {
    nPrintf("*** No se cumple la exclusion mutua\n");
    aprobado= FALSE;
  }
  else
    nPrintf("Test aprobado.\n");
  nDestroyMutex(mutex);
}

/***********************************************
 * Validacion de la no exclusion mutua
 ***********************************************/

void ValidarNoExclusionMutua() {
  nTask t1, t2, t3;
  int i;
  nSetTimeSlice(0);

  nPrintf("**********************************************************\n");
  nPrintf("Test de *no* exclusion mutua: Si se piden mutex distintos,\n");
  nPrintf("las tareas *no* se deben excluir mutuamente.\n");
  nPrintf("**********************************************************\n");

  for (i=0; i<10; i++) {
    int pausa= 100;
    int ini= nGetTime();
    int duracion;
    int verif1= LIBRE, verif2= LIBRE, verif3= LIBRE;
    nMutex mutex1= nMakeMutex();
    nMutex mutex2= nMakeMutex();
    nMutex mutex3= nMakeMutex();
    t1= nEmitTask(TestProc1, mutex1, pausa, &verif1);
    t2= nEmitTask(TestProc1, mutex2, pausa, &verif2);
    t3= nEmitTask(TestProc1, mutex3, pausa, &verif3);
    nWaitTask(t1);   nWaitTask(t2);   nWaitTask(t3);
    duracion= nGetTime()-ini;
    nPrintf("duracion= %d\n", duracion);
    if ( duracion<=pausa+20) {
      nPrintf("Test aprobado.\n");
      break;
    }
    if (i==9) {
      nPrintf("*** El test toma mas tiempo del necesario.  Test no aprobado.\n");
      aprobado= FALSE;
    }
    else
      nPrintf("El test toma mas tiempo del necesario.  Se hara otro intento.\n");
    nDestroyMutex(mutex1);
    nDestroyMutex(mutex2);
    nDestroyMutex(mutex3);
  }
}

/***********************************************
 * Test de esfuerzo
 ***********************************************/

int TestProc2(nMutex mutex, int iter, int* pverif) {
  int rc= EXITO;
  int i;
  while (iter--) {
    nRequest(mutex);
    if (*pverif==TOMADO)
      rc= FRACASO;
    *pverif= TOMADO;
    for(i=0; i<10000;i++)
      ;
    *pverif= LIBRE;
    nRelease(mutex);
  }
  return rc;
}

void TestEsfuerzo() {
  nSetTimeSlice(1);

  nPrintf("************************************************************\n");
  nPrintf("Test de esfuerzo: verifica la robustez lanzado varias tareas\n");
  nPrintf("que piden mutexes compartidos.\n");
  nPrintf("************************************************************\n");
 
  {
    int ntasks= 100;
    int nmutexes= 10;
    nTask* tasks= (nTask*)nMalloc(ntasks*sizeof(nTask));
    nMutex* mutexes= (nMutex*)nMalloc(nmutexes*sizeof(nMutex));
    int* verifs= (int*)nMalloc(nmutexes*sizeof(int));
    int j;
    int nfracasos= 0;
    for (j= 0; j<nmutexes; j++) {
      mutexes[j]= nMakeMutex();
      verifs[j]= 0;
    }
    for (j= 0; j<ntasks; j++)
      tasks[j]= nEmitTask(TestProc2, mutexes[j%nmutexes], 100,
                          &verifs[j%nmutexes]);
    for (j= 0; j<ntasks; j++)
      nfracasos+= nWaitTask(tasks[j]);

    if (nfracasos>0) {
      nPrintf("*** Se detectaron %d problemas de exclusion mutua.  Test no aprobado\n");
      aprobado= FALSE;
    }
    else
      nPrintf("Test aprobado.\n");

    for (j= 0; j<nmutexes; j++)
      nDestroyMutex(mutexes[j]);
    nFree(tasks); nFree(mutexes); nFree(verifs);
  }
}

/*****************************************************************
 * Validacion de que no se produzca la inversion de prioridades
 *****************************************************************/

int MidPri(volatile int *pfin) {
  nSetTaskName("MidPri");
  nSetPriority(1);
 
  nPrintf("MidPri lanzada\n");

  while (!*pfin)
    ;
 
  nPrintf("MidPri terminada\n");
  return 0;
}
 
int HiPri(nMutex mutex, int *pfin, int delta) {
  nSetTaskName("HiPri");
  nPrintf("HiPri lanzada delta=%d\n", delta);
  if (delta!=0)
    dormir(delta);
  nPrintf("Pidiendo mutex\n");
  nRequest(mutex);
  nRelease(mutex);
  nPrintf("HiPri terminada\n");
  *pfin= TRUE;
  return 0;
}

void ValidarPrioridadEfectivaSetPriority() {
  nTask hipriTask, midpriTask;
  int fin= FALSE;
  nMutex mutex= nMakeMutex();
 
  nPrintf("**************************************************************\n");
  nPrintf("Validacion del calculo de la prioridad efectiva: nSetPriority.\n");
  nPrintf("Este test valida que no ocurra la inversion de prioridades.\n");
  nPrintf("Si este test no termina, quiere decir que probablemente la\n");
  nPrintf("prioridad efectiva no se recalcula bien en nSetPriority.\n");
  nPrintf("**************************************************************\n");

  nSetTimeSlice(1);
  nSetTaskName("LoPri");
 
  nRequest(mutex); /* Me aseguro que tengo el mutex */
  nSetPriority(0);
  midpriTask= nEmitTask(MidPri, &fin);
  dormir(10);
  hipriTask= nEmitTask(HiPri, mutex, &fin, 0);
  dormir(10);
  nSetPriority(2); /* nMain corre con la menor prioridad */
  nRelease(mutex); /* devuelvo el semaforo */
 
  ValidarPrioridadIgualA(2); /* deberia estar corriendo en prioridad 2 */

  nWaitTask(hipriTask);
  nWaitTask(midpriTask);
  nDestroyMutex(mutex);


  nPrintf("Test aprobado.\n");
}

void ValidarPrioridadEfectivaRequest() {
  nTask hipriTask, midpriTask;
  int fin= FALSE;
  nMutex mutex= nMakeMutex();
 
  nPrintf("***********************************************************\n");
  nPrintf("Validacion del calculo de la prioridad efectiva: nRequest.\n");
  nPrintf("Este test valida que no ocurra la inversion de prioridades.\n");
  nPrintf("Si este test no termina, quiere decir que probablemente la\n");
  nPrintf("prioridad efectiva no se recalcula bien en nRequest.\n");
  nPrintf("***********************************************************\n");
 
  nSetTimeSlice(1);
  nSetTaskName("LoPri");
 
  nRequest(mutex); /* Me aseguro que tengo el mutex */
  nSetPriority(0);
  midpriTask= nEmitTask(MidPri, &fin);
  hipriTask= nEmitTask(HiPri, mutex, &fin, 10);
  nPrintf("Cambiando la prioridad de LoPri de 0 a 2\n");
  nSetPriority(2); /* nMain corre con la menor prioridad */
  dormir(20);
  nRelease(mutex); /* devuelvo el mutex */
 
  ValidarPrioridadIgualA(2); /* Deberia estar corriendo en prioridad 2 */

  nWaitTask(hipriTask);
  nWaitTask(midpriTask);
  nDestroyMutex(mutex);
 
  nPrintf("Test aprobado.\n");
}

/***********************************************
 * Inversion de prioridades con 4 tareas
 ***********************************************/

int Pri2(volatile int *pfin0, volatile int *pfin1) {
  nSetTaskName("Pri2");
  nSetPriority(2);
 
  nPrintf("Pri2 lanzada\n");
 
  while (!*pfin0)
    ;
  while (!*pfin1)
    ;
 
  nPrintf("Pri2 terminada\n");
  return 0;
}

int PriN(nMutex mutex, int pri, int delta, int *pfin) {
  nSetTaskName("Pri%d", pri);
  nSetPriority(pri);
  nPrintf("Pri%d lanzada\n", pri);

  dormir(delta);
  nRequest(mutex);
  nRelease(mutex);

  *pfin= TRUE;
  nPrintf("Pri%d terminada\n", pri);
  return 0;
}
 
int Inversionx4() {
  nTask t0, t1, t2; /* t0 con prioridad 0, t1 con 1, t2 con 2 */
  int fin0= FALSE, fin1= FALSE;
  nMutex mutex0= nMakeMutex();
  nMutex mutex1= nMakeMutex();
 
  nPrintf("**********************************************************\n");
  nPrintf("Inversion de prioridades: caso 4 tareas.\n");
  nPrintf("Si este test no termina, quiere decir que probablemente la\n");
  nPrintf("prioridad efectiva no se recalcula bien en nRelease.\n");
  nPrintf("**********************************************************\n");
 
  nSetTimeSlice(1);
  nSetTaskName("Pri3");
 
  nRequest(mutex1);
  nRequest(mutex0); /* Me aseguro de que tengo los mutexes */

  nSetPriority(0);
  t0= nEmitTask(PriN, mutex0, 0, 30, &fin0);
  t1= nEmitTask(PriN, mutex1, 1, 60, &fin1);
  t2= nEmitTask(Pri2, &fin0, &fin1);

  nPrintf("Cambiando la prioridad de Pri3 de 0 a 3\n");
  nSetPriority(3); /* nMain corre con la peor prioridad */
  trabajar(100);
  nRelease(mutex0); /* devuelvo el primer mutex */
  trabajar(100);
  nRelease(mutex1); /* devuelvo el segundo mutex */
 
  ValidarPrioridadIgualA(3); /* Deberia estar corriendo en prioridad 3 */
 
  nWaitTask(t0);
  nWaitTask(t1);
  nWaitTask(t2);
  nDestroyMutex(mutex0);
  nDestroyMutex(mutex1);
 
  nPrintf("Test aprobado.\n");
}

/***********************************************
 * Main
 ***********************************************/

int nMain(int argc, char **argv)
{
  nSetTaskName("nMain");
  ValidarExclusionMutua();
  ValidarNoExclusionMutua();
  ValidarMejorPrioridad();
  ValidarPrioridadEfectivaSetPriority();
  ValidarPrioridadEfectivaRequest();
  Inversionx4();
  TestEsfuerzo();

  if (aprobado) {
    nPrintf("\n\n\n\nFelicitaciones!! Todos los tests fueron exitosos.\n");
    nPrintf("Ud. puede entregar su tarea.\n\n\n\n");
  }
  else {
    nPrintf("Algunos los tests no fueron exitosos.  Revise su tarea.\n");
    nPrintf("No entregue la tarea hasta que todos los tests sean exitosos.\n");
  }

  return 0;
}
