#include "nSysimp.h"

/*************************************************************
 * Manejo de Semaforos
 *************************************************************/

typedef struct nMutex
{
  nTask owner;
  struct nMutex *prev;
  struct Queue *queue;
}
  *nMutex;

#define NOVOID_NMUTEX

#include "nSystem.h"

nMutex nMakeMutex()
{
  nMutex mutex;

  mutex= (nMutex) nMalloc(sizeof(*mutex));
  mutex->owner= NULL;
  mutex->prev= NULL;
  mutex->queue= MakeQueue();

  return mutex;
}

void nRequest(nMutex mutex)
{
  START_CRITICAL();

  // nPrintf("nRequest de %s con pri=%d\n",
  //         current_task->taskname, current_task->pri);

  if (mutex->owner==NULL)
  {
    mutex->owner= current_task;
    mutex->prev= current_task->last_mutex;
    current_task->last_mutex= mutex;
    // nPrintf("nRequest de %s con pri=%d %d, libre\n",
    //       current_task->taskname, current_task->pri, current_task->std_pri);
  }
  else
  {
    nTask owner= mutex->owner;

    current_task->status= WAIT_MUTEX;
    PutTask(mutex->queue, current_task);

    computePriority(owner);
    // nPrintf("nRequest de %s con pri=%d %d, mutex tomado por %s, nueva pri=%d %d\n",
    //         current_task->taskname, current_task->pri, current_task->std_pri,
    //         owner->taskname, owner->pri, owner->std_pri);

    ResumeNextReadyTask();
  }

  END_CRITICAL();
}

void computePriority(nTask task)
{
  int best_pri= task->std_pri;
  nMutex mutex;

  for (mutex= task->last_mutex; mutex!=NULL; mutex= mutex->prev)
  {
    int pri= BestWaitingPriority(mutex->queue);
    if (pri<best_pri)
      best_pri= pri;
  }

  task->pri= best_pri;
  // nPrintf("priority of %s is %d %d\n", task->taskname,
  //         task->pri, task->std_pri);
}

void nRelease(nMutex mutex)
{
  START_CRITICAL();

  current_task->last_mutex= mutex->prev;
  mutex->owner= NULL;
  computePriority(current_task);
  // nPrintf("nRelease de %s, nueva pri=%d %d cola %s\n",
  //         current_task->taskname, current_task->pri, current_task->std_pri,
  //         EmptyQueue(mutex->queue) ? "vacia" : "no vacia");

  PushTask(ready_queue, current_task); /* Sigue estando ready */
  if (!EmptyQueue(mutex->queue))
  {
    nTask wait_task= GetTask(mutex->queue);
    // nPrintf("Aceptando nRequest de %s con pri=%d %d\n",
    //         wait_task->taskname, wait_task->pri, wait_task->std_pri);
    wait_task->status= READY;
       /* wait_task ahora pasa al estado ready y queremos que
        * tome la CPU.  La siguiente secuencia es la unica forma
        * de transferir la CPU directamente a otra tarea.
        */
    mutex->owner= wait_task;
    mutex->prev= wait_task->last_mutex;
    wait_task->last_mutex= mutex;
    PushTask(ready_queue, wait_task);
  }
  ResumeNextReadyTask(); /* wait_task es la primera en la cola! */

  END_CRITICAL();
}

void nDestroyMutex(nMutex mutex)
{
  if (mutex->owner!=NULL || !EmptyQueue(mutex->queue) )
    nFatalError("nDestroyMutex",
      "Se intenta destruir un mutex con tareas pendientes\n");
  DestroyQueue(mutex->queue);
  nFree(mutex);
}

