# 0 "crt0.S"
# 0 "<built-in>"
# 0 "<command-line>"
# 1 "crt0.S"
# 12 "crt0.S"
# 1 "/opt/riscv/riscv64-unknown-elf/include/newlib.h" 1 3
# 14 "/opt/riscv/riscv64-unknown-elf/include/newlib.h" 3
# 1 "/opt/riscv/riscv64-unknown-elf/include/_newlib_version.h" 1 3
# 15 "/opt/riscv/riscv64-unknown-elf/include/newlib.h" 2 3
# 13 "crt0.S" 2




#=========================================================================
# crt0.S : Entry point for RISC-V user programs
#=========================================================================

  .text
  .global _LRV32IM_start
  .type _LRV32IM_start, @function
_LRV32IM_start:
  # Initialize global pointer
.option push
.option norelax
1:auipc gp, %pcrel_hi(__global_pointer$)
  addi gp, gp, %pcrel_lo(1b)
.option pop

  # Init stack pointer
  li sp, 2
  slli sp, sp, 26 # 0x2000000

  # Clear the bss segment
  la a0, _edata
  la a2, _end
  sub a2, a2, a0
  li a1, 0
  call memset

  # Make reference to atexit weak to avoid unconditionally pulling in
  # support code. Refer to comments in __atexit.c for more details.
  .weak atexit
  la a0, atexit
  beqz a0, .Lweak_atexit
  .weak __libc_fini_array


  la a0, __libc_fini_array # Register global termination functions
  call atexit # to be called upon exit

.Lweak_atexit:

  call __libc_init_array # Run global initialization functions

# call _ini_intr

  li a0, 0 # a0 = argc
  li a1, 0 # a1 = argv
  li a2, 0 # a2 = envp = NULL
  call main
  call stop
  tail exit
  .size _LRV32IM_start, .-_LRV32IM_start
