#include <stdlib.h>
#include <string.h>
#include "term.h"

#define SIZEM (64*1024)
char m[SIZEM];

// Checks that k is prime by software.  Don't use this as your answer in P2.f
static void checkPrime(int k, int reportedPrime) {
  int i= 2;
  while (i<k) {
    if (k%i==0)
      break;
    i++;
  }
  if (i<k && reportedPrime) {
    showChar('\n');
    showInt(k);
    showStr(" is wrongly reported\n");
    showStr("as prime\n");
    showInt(i);
    showStr(" is a factor\n");
    stop(1);
  }
  else if (i>=k && !reportedPrime) {
    showChar('\n');
    showInt(k);
    showStr(" is wrongly reported\n");
    showStr("as not prime\n");
    stop(1);
  }
     
}

int main() {
  // Don't use printf! Use functions declared in term.h,
  // like showStr, showChar, readLin, etc.
  for (;;) {
    char lin[81];
    showStr("Max prime number? ");
    readLine(lin, 80);
    int n= atoi(lin);
    if (n>=SIZEM) {
      showStr("n must be less than ");
      showInt(SIZEM);
      showChar('\n');
      continue;
    }
    showStr("Computing prime numbers\n");
    showStr("less or equal to ");
    showInt(n);
    showChar('\n');
    // Begin simplified sieve of Eratosthenes
    // This is exactly the algorithm that implements primegen module
    memset(m, 0, SIZEM);
    for (int i=3; i<=n; i++) {
      for (int j= 2*i; j<=n; j+=i)
        m[j]= 1;
    }
    // End of simplified sieve of Eratosthenes
    // At the end, prime numbers are { k | k<=n and m[k] is 0} U { 2 }
    showStr("2 "); // Prime number 2 is a special case
    int cnt= 1;
    for (int k=3; k<=n; k += 2) {
      checkPrime(k,!m[k]);
      if (!m[k]) {
        showInt(k);
        showChar(' ');
        if (++cnt == 6) { // Only 6 primes in a line
          showChar('\n');
          cnt= 0;
        }
      }
    }
    if (cnt!=0)
      showChar('\n');
  }
}
